/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class AnBn
extends RegularPumpingLemma {
    @Override
    public String getTitle() {
        return "a^n b^n : n >= 0";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>n</sup>b<sup>n</sup></i> : <i>n</i> " + GREATER_OR_EQ + " 0";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i></sup>\".  The <i>y</i> value thus would be a multiple of \"a\".  For any <i>i</i> " + NOT_EQUAL + " 1, n<sub>a</sub> " + NOT_EQUAL + " n<sub>b</sub>, giving a string " + "which is not in the language.  Thus, the language is not regular.";
    }

    @Override
    protected void chooseW() {
        this.w = AnBn.pumpString("a", this.m) + AnBn.pumpString("b", this.m);
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{4, 18};
    }

    @Override
    public boolean isInLang(String string) {
        int n;
        char[] cArray = new char[]{'a', 'b'};
        if (LemmaMath.isMixture(string, cArray)) {
            return false;
        }
        int n2 = LemmaMath.countInstances(string, 'a');
        return n2 == (n = LemmaMath.countInstances(string, 'b'));
    }
}

