/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class AnBkCnk
extends RegularPumpingLemma {
    @Override
    public String getTitle() {
        return "a^n b^k c^(n+k) : n >= 0, k >= 0";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>n</sup>b<sup>k</sup>c<sup>n+k</sup></i> : <i>n</i> " + GREATER_OR_EQ + " 0, <i>k</i> " + GREATER_OR_EQ + " 0";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i></sup>c<sup>2<i>m</i></sup>\".  The <i>y</i> value thus would be a multiple of \"a\".  If <i>i</i> = 0, the string becomes at most \"a<sup><i>m</i>-1</sup>b<sup><i>m</i></sup>c<sup>2<i>m</i></sup>\", which is not in the language.  Thus, the language is not regular.";
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 9};
    }

    @Override
    protected void chooseW() {
        this.w = AnBkCnk.pumpString("a", this.getM()) + AnBkCnk.pumpString("b", this.getM()) + AnBkCnk.pumpString("c", this.getM() * 2);
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    public boolean isInLang(String string) {
        int n;
        int n2;
        char[] cArray = new char[]{'a', 'b', 'c'};
        if (LemmaMath.isMixture(string, cArray)) {
            return false;
        }
        int n3 = LemmaMath.countInstances(string, 'a');
        return n3 + (n2 = LemmaMath.countInstances(string, 'b')) == (n = LemmaMath.countInstances(string, 'c'));
    }
}

