/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class W1VVrW2
extends ContextFreePumpingLemma {
    @Override
    public String getTitle() {
        return "w1 v v^R w2 : na(w1) = na(w2), |v|>=3, w1 & w2 element_of {ab}*";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>w<sub>1</sub>vv<sup>R</sup>w<sub>2</sub></i>, : <i>n<sub>a</sub></i>(<i>w<sub>1</sub></i>) = <i>n<sub>a</sub></i>(<i>w<sub>2</sub></i>),  |<i>v</i>| " + GREATER_THAN + " 3,  <i>v</i>, <i>w<sub>1</sub>, " + "w<sub>2</sub> " + ELEMENT_OF + " " + AB_STAR;
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = true;
        this.explanation = "Because this is a context-free language, a valid decomposition exists.  If |'v'| " + GREATER_THAN + " 3, " + "or if <i>m</i> " + GREATER_OR_EQ + " 8 and there are no \"b\"s in w<sub>1</sub> and w<sub>2</sub>, one could " + "just pump single opposite characters in 'v' and 'v<sup>R</sup>' repeatedly to find a valid decomposition.  " + "For example, if |'v'| = 4, then <i>v</i> could equal the fourth character of 'v' and <i>y</i> the first " + "character of 'v<sup>R</sup>'.  Otherwise, if <i>m</i> " + GREATER_OR_EQ + " 8 and |v| = 3, one could just " + "pump the first \"b\" value in w<sub>1</sub> or w<sub>2</sub>.";
    }

    @Override
    protected void addCases() {
    }

    @Override
    public void chooseI() {
        this.i = 3;
    }

    @Override
    protected void chooseW() {
        int n = this.m / 2;
        this.w = W1VVrW2.pumpString("ab", n) + "abbbba" + W1VVrW2.pumpString("ab", n);
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 15};
    }

    private int[] getVVr(String string) {
        if (string.length() < 6) {
            return null;
        }
        for (int i = string.length() - 1; i >= 5; --i) {
            for (int j = 0; j <= i - 5; ++j) {
                if ((i - j) % 2 != 1 || string.charAt(j) != string.charAt(i)) continue;
                boolean bl = true;
                for (int k = 0; k <= (i - j) / 2; ++k) {
                    if (string.charAt(j + k) == string.charAt(i - k)) continue;
                    bl = false;
                }
                if (!bl || LemmaMath.countInstances(string.substring(0, j), 'a') != LemmaMath.countInstances(string.substring(i + 1), 'a')) continue;
                return new int[]{j, i};
            }
        }
        return null;
    }

    @Override
    public void chooseDecomposition() {
        int[] nArray = this.getVVr(this.w);
        String string = this.w.substring(0, nArray[0]);
        String string2 = this.w.substring(nArray[1] + 1);
        if (nArray[1] - nArray[0] > 5 || LemmaMath.countInstances(string, 'b') == 0 && LemmaMath.countInstances(string2, 'b') == 0) {
            this.setDecomposition(new int[]{nArray[0] + (nArray[1] - nArray[0]) / 2, 1, 0, 1});
        } else if (string.indexOf(98) > -1) {
            this.setDecomposition(new int[]{string.indexOf(98), 1, 0, 0});
        } else {
            this.setDecomposition(new int[]{string2.indexOf(98) + nArray[1] + 1, 1, 0, 0});
        }
    }

    @Override
    public boolean isInLang(String string) {
        char[] cArray = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(string, cArray)) {
            return false;
        }
        return this.getVVr(string) != null;
    }
}

