/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class AkBnCnDj
extends ContextFreePumpingLemma {
    @Override
    public String getTitle() {
        return "a^k b^n c^n d^j : j != k";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>k</sup>b<sup>n</sup>c<sup>n</sup>d<sup>j</sup></i> : <i>j</i> " + NOT_EQUAL + " k";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = true;
        this.explanation = "Because this is a context-free language, a valid decomposition exists.  For all m " + GREATER_OR_EQ + " 2, " + "if <i>n</i> " + GREATER_OR_EQ + " 1, <i>v</i> could equal \"b\" and <i>y</i> could equal \"c\".  If <i>n</i> " + "= 0 and <i>k</i> & <i>j</i> " + GREATER_OR_EQ + " 1, <i>v</i> could equal \"a\" and <i>y</i> could equal " + "\"d\".  If <i>n</i> = 0 and only one of <i>k</i> or <i>j</i> " + GREATER_OR_EQ + " 1, <i>v</i> could equal \"a\" " + "or \"d\" (whichever one is in the string).  and <i>y</i> could be empty.  This covers all possible combinations.";
    }

    @Override
    public void chooseI() {
        int n = LemmaMath.countInstances(this.getV(), 'a') + LemmaMath.countInstances(this.getY(), 'a');
        this.i = n == 1 ? 2 : 0;
    }

    @Override
    protected void chooseW() {
        this.w = AkBnCnDj.pumpString("a", this.m) + AkBnCnDj.pumpString("b", this.m) + AkBnCnDj.pumpString("c", this.m) + AkBnCnDj.pumpString("d", this.m + 1);
    }

    @Override
    public void chooseDecomposition() {
        int n = this.w.indexOf(97);
        int n2 = this.w.indexOf(98);
        int n3 = this.w.indexOf(99);
        int n4 = this.w.indexOf(100);
        if (n2 > -1 && n3 > -1) {
            this.setDecomposition(new int[]{n3 - 1, 1, 0, 1});
        } else if (n > -1 && n4 > -1) {
            this.setDecomposition(new int[]{n4 - 1, 1, 0, 1});
        } else {
            super.chooseDecomposition();
        }
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 5};
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string.indexOf("d") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") == -1 && string2.indexOf("c") == -1 && string2.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{0, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string.indexOf("d") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1 && string2.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AkBnCnDj.this.m - 2, 1, 0, 2};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string.indexOf("d") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1 && string2.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AkBnCnDj.this.m - 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string.indexOf("d") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1 && string2.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AkBnCnDj.this.m - 1, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string.indexOf("d") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1 && string2.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AkBnCnDj.this.m, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string.indexOf("d") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") > -1 && string2.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s followed by \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AkBnCnDj.this.m - 2, 1, 0, 2};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string.indexOf("d") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1 && string2.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AkBnCnDj.this.m - 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") > -1 && string.indexOf("d") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1 && string2.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s followed by \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AkBnCnDj.this.m - 1, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") == -1 && string.indexOf("c") > -1 && string.indexOf("d") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1 && string2.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AkBnCnDj.this.m, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") == -1 && string.indexOf("c") > -1 && string.indexOf("d") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1 && string2.indexOf("d") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s and y is a string of \"c\"s followed by \"d\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{3 * AkBnCnDj.this.m - 2, 1, 0, 2};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") == -1 && string.indexOf("c") > -1 && string.indexOf("d") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") == -1 && string2.indexOf("d") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s and y is a string of \"d\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{3 * AkBnCnDj.this.m - 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") == -1 && string.indexOf("c") > -1 && string.indexOf("d") > -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") == -1 && string2.indexOf("d") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s followed by \"d\"s and y is a string of \"d\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{3 * AkBnCnDj.this.m - 1, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string.indexOf("d") > -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") == -1 && string2.indexOf("d") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"d\"s and y is a string of \"d\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{3 * AkBnCnDj.this.m, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() == 0 && string2.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AkBnCnDj.this.m, 0, 1, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() > 0 && string2.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AkBnCnDj.this.m, 1, 0, 0};
            }
        });
    }

    @Override
    public boolean isInLang(String string) {
        char[] cArray = new char[]{'a', 'b', 'c', 'd'};
        if (LemmaMath.isMixture(string, cArray)) {
            return false;
        }
        int[] nArray = new int[]{0, 0, 0, 0};
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            if (string.charAt(n) != cArray[n2]) {
                ++n2;
                continue;
            }
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
            ++n;
        }
        return nArray[1] == nArray[2] && nArray[0] != nArray[3];
    }
}

