/*
 * Decompiled with CFR 0.152.
 */
package gui.viewer;

import automata.Automaton;
import automata.Note;
import automata.State;
import automata.event.AutomataStateEvent;
import automata.event.AutomataStateListener;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import gui.JMultiLineToolTip;
import gui.editor.EditorPane;
import gui.viewer.AutomatonDrawer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.Scrollable;

public class AutomatonPane
extends JPanel
implements Scrollable {
    private EditorPane myCreator;
    private Point tp = null;
    protected AutomatonDrawer drawer;
    public AffineTransform transform = new AffineTransform();
    private boolean adapt;
    private boolean transformNeedsReform = true;
    private JTable table;
    private double scaleBy = 1.0;

    public AutomatonPane(AutomatonDrawer automatonDrawer) {
        this(automatonDrawer, true);
        this.setLayout(null);
    }

    @Override
    public JToolTip createToolTip() {
        return new JMultiLineToolTip();
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        try {
            return this.transformFromAutomatonToView(this.drawer.stateAtPoint(mouseEvent.getPoint()).getPoint());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (!this.drawer.doesDrawStateLabels()) {
            State state = this.drawer.stateAtPoint(mouseEvent.getPoint());
            if (state == null) {
                return null;
            }
            return state.getLabel();
        }
        return null;
    }

    public AutomatonPane(AutomatonDrawer automatonDrawer, boolean bl) {
        this.drawer = automatonDrawer;
        this.adapt = bl;
        this.setPreferredSize(new Dimension(400, 300));
        Listener listener = new Listener();
        automatonDrawer.getAutomaton().addStateListener(listener);
        automatonDrawer.getAutomaton().addTransitionListener(listener);
        this.addComponentListener(listener);
        this.setToolTipText("Beavis");
        this.setOpaque(true);
    }

    public AutomatonPane(Automaton automaton) {
        this(new AutomatonDrawer(automaton));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.transformNeedsReform) {
            this.reformTransform(new Rectangle(this.getSize()));
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.transform(this.transform);
        this.drawer.drawAutomaton(graphics);
        ArrayList arrayList = this.getDrawer().getAutomaton().getNotes();
        for (int i = 0; i < arrayList.size(); ++i) {
            Note note = (Note)arrayList.get(i);
            note.updateView();
        }
    }

    @Override
    public void printComponent(Graphics graphics) {
        if (this.transformNeedsReform) {
            this.reformTransform(graphics.getClipBounds());
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, graphics.getClipBounds().width, graphics.getClipBounds().height);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.transform(this.transform);
        this.drawer.invalidate();
        this.drawer.drawAutomaton(graphics);
        ArrayList arrayList = this.getDrawer().getAutomaton().getNotes();
        for (int i = 0; i < arrayList.size(); ++i) {
            Note note = (Note)arrayList.get(i);
            note.updateView();
        }
    }

    protected Rectangle getAutomatonBounds() {
        Rectangle rectangle = this.drawer.getBounds();
        if (rectangle == null) {
            return new Rectangle(this.getSize());
        }
        return rectangle;
    }

    public void reformTransform(Rectangle rectangle) {
        double d;
        this.transformNeedsReform = false;
        Rectangle rectangle2 = new Rectangle(this.getAutomatonBounds());
        if (!this.adapt) {
            Rectangle rectangle3 = this.getVisibleRect();
            Point point = new Point((int)((double)rectangle3.x - this.transform.getTranslateX()), (int)((double)rectangle3.y - this.transform.getTranslateY()));
            Point point2 = new Point(Math.min(rectangle2.x, Math.min(0, point.x)), Math.min(rectangle2.y, Math.min(0, point.y)));
            this.transform = new AffineTransform();
            this.drawer.setTransform(this.transform);
            this.drawer.invalidateBounds();
            this.transform.translate(-point2.x, -point2.y);
            this.transform.scale(this.scaleBy, this.scaleBy);
            Dimension dimension = new Dimension(Math.max(rectangle2.width + rectangle2.x, point.x + rectangle3.width) - point2.x, Math.max(rectangle2.height + rectangle2.y, point.y + rectangle3.height) - point2.y);
            if (dimension.equals(this.getPreferredSize())) {
                return;
            }
            this.setPreferredSize(dimension);
            this.revalidate();
            this.scrollRectToVisible(rectangle3);
            return;
        }
        this.transform = new AffineTransform();
        rectangle2.grow(20, 20);
        Rectangle rectangle4 = rectangle;
        double d2 = rectangle2.getWidth() / rectangle2.getHeight();
        double d3 = rectangle4.getWidth() / rectangle4.getHeight();
        if (d2 > d3) {
            d = rectangle2.getWidth() / d3;
            rectangle2.setRect(rectangle2.getX(), rectangle2.getY() - (d -= rectangle2.getHeight()) / 2.0, rectangle2.getWidth(), rectangle2.getHeight() + d);
        } else {
            d = rectangle2.getHeight() * d3;
            rectangle2.setRect(rectangle2.getX() - (d -= rectangle2.getWidth()) / 2.0, rectangle2.getY(), rectangle2.getWidth() + d, rectangle2.getHeight());
        }
        d = rectangle4.getWidth() / rectangle2.getWidth();
        this.transform.scale(d, d);
        System.out.println(d + "..." + (rectangle4.getX() - rectangle2.getX()));
        this.transform.translate(rectangle4.getX() - rectangle2.getX(), rectangle4.getY() - rectangle2.getY());
    }

    public void transformMouseEvent(MouseEvent mouseEvent) {
        if (this.transformNeedsReform) {
            this.reformTransform(new Rectangle(this.getSize()));
        }
        Point point = new Point();
        Point point2 = mouseEvent.getPoint();
        try {
            this.transform.inverseTransform(point2, point);
            mouseEvent.translatePoint(point.x - point2.x, point.y - point2.y);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    public Point transformFromAutomatonToView(Point point) {
        return (Point)this.transform.transform(point, new Point());
    }

    public Point transformFromViewToAutomaton(Point point) {
        try {
            return (Point)this.transform.inverseTransform(point, new Point());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return new Point(point);
        }
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        this.transformMouseEvent(mouseEvent);
        super.processMouseEvent(mouseEvent);
    }

    @Override
    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.transformMouseEvent(mouseEvent);
        super.processMouseMotionEvent(mouseEvent);
    }

    public AutomatonDrawer getDrawer() {
        return this.drawer;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 5;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.adapt) {
            return true;
        }
        return this.getPreferredSize().width < this.getParent().getSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.adapt) {
            return true;
        }
        return this.getPreferredSize().height < this.getParent().getSize().height;
    }

    public Point getAutomatonOrigin() {
        return new Point(-((int)this.transform.getTranslateX()), -((int)this.transform.getTranslateY()));
    }

    public void fitToBounds(int n) {
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = this.drawer != null && this.drawer.getBounds() != null ? new Rectangle(this.drawer.getBounds()) : new Rectangle(0, 0);
        rectangle2.grow(n, n);
        rectangle.y = 0;
        rectangle.x = 0;
        State[] stateArray = this.drawer.getAutomaton().getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            Point point = stateArray[i].getPoint();
            point.setLocation((point.getX() - rectangle2.getX()) * (rectangle.getWidth() / rectangle2.getWidth()), (point.getY() - rectangle2.getY()) * (rectangle.getHeight() / rectangle2.getHeight()));
            stateArray[i].setPoint(point);
        }
    }

    @Override
    public Component add(Component component) {
        if (component instanceof JTable) {
            this.table = (JTable)component;
        }
        return super.add(component);
    }

    public void setTablePoint(Point point) {
        this.tp = point;
    }

    @Override
    public void doLayout() {
        try {
            super.doLayout();
            this.table.setLocation(this.tp);
        }
        catch (NullPointerException nullPointerException) {
            super.doLayout();
        }
    }

    public void setAdapt(boolean bl) {
        this.adapt = bl;
        this.transformNeedsReform = true;
        this.repaint();
    }

    public boolean getAdapt() {
        return this.adapt;
    }

    public void setCreator(EditorPane editorPane) {
        this.myCreator = editorPane;
    }

    public EditorPane getCreator() {
        return this.myCreator;
    }

    public void setScale(double d) {
        this.scaleBy = d;
    }

    public double getScale() {
        return this.scaleBy;
    }

    public void requestTransform() {
        this.transformNeedsReform = true;
        this.repaint();
    }

    private class Listener
    extends ComponentAdapter
    implements AutomataStateListener,
    AutomataTransitionListener {
        private Listener() {
        }

        @Override
        public void automataTransitionChange(AutomataTransitionEvent automataTransitionEvent) {
            AutomatonPane.this.transformNeedsReform = true;
            AutomatonPane.this.repaint();
        }

        @Override
        public void automataStateChange(AutomataStateEvent automataStateEvent) {
            AutomatonPane.this.transformNeedsReform = true;
            AutomatonPane.this.repaint();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (AutomatonPane.this.adapt) {
                AutomatonPane.this.transformNeedsReform = true;
            }
            AutomatonPane.this.repaint();
        }
    }
}

