/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import gui.tree.DefaultTreeDrawer;
import gui.tree.TreeDrawer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class TreePanel
extends JComponent {
    private TreeDrawer treeDrawer;

    public TreePanel(TreeModel treeModel) {
        this.treeDrawer = new DefaultTreeDrawer(treeModel);
    }

    public TreePanel(TreeDrawer treeDrawer) {
        this.treeDrawer = treeDrawer;
    }

    public TreeDrawer getTreeDrawer() {
        return this.treeDrawer;
    }

    public void setTreeDrawer(TreeDrawer treeDrawer) {
        this.treeDrawer = treeDrawer;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        Dimension dimension = this.getSize();
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.setColor(Color.black);
        this.treeDrawer.draw(graphics2D, dimension);
    }

    public TreeNode nodeAtPoint(Point2D point2D) {
        return this.treeDrawer.nodeAtPoint(point2D, this.getSize());
    }
}

