/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import gui.tree.DefaultNodeDrawer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.WeakHashMap;
import javax.swing.tree.TreeNode;

public class SelectNodeDrawer
extends DefaultNodeDrawer {
    protected WeakHashMap selectedNodes = new WeakHashMap();

    @Override
    public void draw(Graphics2D graphics2D, TreeNode treeNode) {
        Color color = graphics2D.getColor();
        if (this.isSelected(treeNode)) {
            graphics2D.setColor(color.darker());
        }
        super.draw(graphics2D, treeNode);
        graphics2D.setColor(color);
    }

    public boolean isSelected(TreeNode treeNode) {
        return this.selectedNodes.containsKey(treeNode);
    }

    public void setSelected(TreeNode treeNode, boolean bl) {
        if (bl) {
            this.selectedNodes.put(treeNode, null);
        } else {
            this.selectedNodes.remove(treeNode);
        }
    }

    public TreeNode[] getSelected() {
        return this.selectedNodes.keySet().toArray(new TreeNode[0]);
    }

    public void clearSelected() {
        this.selectedNodes.clear();
    }
}

