/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import gui.environment.Universe;
import gui.tree.NodeDrawer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.tree.TreeNode;

public class DefaultNodeDrawer
implements NodeDrawer {
    public static final float NODE_RADIUS = 13.0f;
    public static final Shape NODE_SHAPE = new Ellipse2D.Float(-13.0f, -13.0f, 26.0f, 26.0f);
    public static final Rectangle2D NODE_SIZE = new Rectangle(13, 13, 26, 26);

    @Override
    public void draw(Graphics2D graphics2D, TreeNode treeNode) {
        graphics2D.fill(NODE_SHAPE);
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        graphics2D.draw(NODE_SHAPE);
        String string = treeNode.toString();
        if (string == null) {
            string = "null";
        }
        if (string.length() == 0) {
            string = Universe.curProfile.getEmptyString();
        }
        Rectangle2D rectangle2D = this.getBounds(graphics2D, string);
        int n = (int)rectangle2D.getWidth() >> 1;
        int n2 = (int)(-rectangle2D.getY()) >> 1;
        graphics2D.drawString(string, -n, n2);
        graphics2D.setColor(color);
    }

    public void draw(Graphics2D graphics2D, TreeNode treeNode, boolean bl) {
        graphics2D.fill(new Ellipse2D.Float(-13.0f, -13.0f, 52.0f, 26.0f));
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        graphics2D.draw(new Ellipse2D.Float(-13.0f, -13.0f, 52.0f, 26.0f));
        String string = treeNode.toString();
        if (string == null) {
            string = "null";
        }
        if (string.length() == 0) {
            string = Universe.curProfile.getEmptyString();
        }
        Rectangle2D rectangle2D = this.getBounds(graphics2D, string);
        int n = (int)rectangle2D.getWidth() >> 2;
        int n2 = (int)(-rectangle2D.getY()) >> 1;
        graphics2D.drawString(string, -n, n2);
        graphics2D.setColor(color);
    }

    protected Rectangle2D getBounds(Graphics2D graphics2D, String string) {
        return graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
    }

    @Override
    public Rectangle2D nodeSize() {
        return NODE_SIZE;
    }

    @Override
    public Rectangle2D nodeSize(TreeNode treeNode) {
        return this.nodeSize();
    }

    @Override
    public boolean onNode(TreeNode treeNode, double d, double d2) {
        return Math.sqrt(d * d + d2 * d2) <= 13.0;
    }
}

