/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Configuration;
import gui.sim.ConfigurationIcon;
import gui.sim.ConfigurationIconFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JToggleButton;

public class ConfigurationButton
extends JToggleButton {
    protected int state = 0;
    private Configuration config = null;
    private ConfigurationIcon icon = null;
    public static final int NORMAL = 0;
    public static final int ACCEPT = 1;
    public static final int REJECT = 2;
    public static final int FREEZE = 3;
    public static final int FOCUSED = 4;
    private static final String[] TEXT = new String[]{"Normal", "Accept", "Reject", "Freeze", "Focused"};
    public static final Color[] STATE_COLOR = new Color[]{new Color(0, 0, 0, 0), new Color(0, 150, 0, 80), new Color(255, 0, 0, 80), new Color(100, 100, 255, 80), new Color(255, 255, 0, 80)};
    protected static final int PADDING = 5;

    public ConfigurationButton(Configuration configuration) {
        this(configuration, 0);
    }

    public ConfigurationButton(Configuration configuration, int n) {
        this.config = configuration;
        this.icon = ConfigurationIconFactory.iconForConfiguration(configuration);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(1);
        this.setState(n);
        this.setPreferredSize(new Dimension(0, 10 + this.icon.getIconHeight()));
    }

    public void setState(int n) {
        if (this.config.isAccept()) {
            n = 1;
        }
        if (n < 0 || n >= TEXT.length) {
            n = 0;
        }
        this.state = n;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(STATE_COLOR[this.state]);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.translate(5, 5);
        this.icon.paintConfiguration(this, (Graphics2D)graphics, this.getWidth() - 10, this.getHeight() - 10);
        graphics.translate(-5, -5);
    }
}

