/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.State;
import gui.editor.Tool;
import gui.regular.FSAToREController;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class StateCollapseTool
extends Tool {
    private FSAToREController controller;

    public StateCollapseTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer, FSAToREController fSAToREController) {
        super(automatonPane, automatonDrawer);
        this.controller = fSAToREController;
    }

    @Override
    public String getToolTip() {
        return "State Collapser";
    }

    @Override
    protected Icon getIcon() {
        URL uRL = this.getClass().getResource("/ICON/state_collapse.gif");
        return new ImageIcon(uRL);
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('o');
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        State state = this.getDrawer().stateAtPoint(mouseEvent.getPoint());
        if (state != null) {
            this.controller.stateCollapse(state);
        }
    }
}

