/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.State;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.environment.FrameFactory;
import gui.environment.Universe;
import gui.regular.ConvertToAutomatonPane;
import gui.viewer.AutomatonPane;
import java.awt.Component;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import regular.Discretizer;

public class REToFSAController {
    private ConvertToAutomatonPane convertPane;
    private FiniteStateAutomaton automaton;
    private Set toDo = new HashSet();
    private Set toDoTransitions = new HashSet();
    private int action = 0;
    private FSATransition transition = null;
    private int transitionNeeded = 0;
    private FSATransition[] replacements = null;
    private boolean catBeginMade = false;
    private boolean catEndMade = false;
    private static final int DEPARENS = 1;
    private static final int DESTAR = 2;
    private static final int DEOR = 3;
    private static final int DECAT = 4;

    public REToFSAController(ConvertToAutomatonPane convertToAutomatonPane, FiniteStateAutomaton finiteStateAutomaton) {
        this.convertPane = convertToAutomatonPane;
        this.automaton = finiteStateAutomaton;
        FSATransition fSATransition = (FSATransition)finiteStateAutomaton.getTransitions()[0];
        if (this.requiredAction(fSATransition.getLabel()) != 0) {
            this.toDo.add(fSATransition);
        }
        this.convertPane.exportAction.setEnabled(false);
        this.nextStep();
    }

    private int requiredAction(String string) {
        if (string.length() <= 1) {
            return 0;
        }
        if (Discretizer.or(string).length > 1) {
            return 3;
        }
        if (Discretizer.cat(string).length > 1) {
            return 4;
        }
        if (string.charAt(string.length() - 1) == '*') {
            return 2;
        }
        if (string.charAt(0) == '(' && string.charAt(string.length() - 1) == ')') {
            return 1;
        }
        throw new IllegalArgumentException("Expression " + string + " not recognized!");
    }

    private FSATransition[] replaceTransition(FSATransition fSATransition, String[] stringArray) {
        AffineTransform affineTransform = new AffineTransform();
        Point point = fSATransition.getFromState().getPoint();
        Point point2 = fSATransition.getToState().getPoint();
        affineTransform.translate(point.x, point.y);
        affineTransform.scale(point.distance(point2), point.distance(point2));
        affineTransform.rotate(Math.atan2(point2.y - point.y, point2.x - point.x));
        FSATransition[] fSATransitionArray = new FSATransition[stringArray.length];
        Point2D.Double double_ = new Point2D.Double(0.2, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.8, 0.0);
        this.automaton.removeTransition(fSATransition);
        for (int i = 0; i < stringArray.length; ++i) {
            double d;
            point = new Point();
            point2 = new Point();
            double_2.y = double_.y = (d = stringArray.length > 1 ? ((double)i / ((double)stringArray.length - 1.0) - 0.5) * 0.5 : 0.0);
            affineTransform.transform(double_, point);
            affineTransform.transform(double_2, point2);
            point.x = Math.max(point.x, 20);
            point.y = Math.max(point.y, 20);
            point2.x = Math.max(point2.x, 20);
            point2.y = Math.max(point2.y, 20);
            State state = this.automaton.createState(point);
            State state2 = this.automaton.createState(point2);
            fSATransitionArray[i] = new FSATransition(state, state2, stringArray[i]);
            this.automaton.addTransition(fSATransitionArray[i]);
            if (this.requiredAction(fSATransitionArray[i].getLabel()) == 0) continue;
            this.toDo.add(fSATransitionArray[i]);
        }
        return fSATransitionArray;
    }

    public void transitionCheck(FSATransition fSATransition) {
        if (this.action != 0) {
            JOptionPane.showMessageDialog(this.convertPane, "We're already in the process of\ndeexpressionifying a transition.", "Already Active", 0);
            return;
        }
        this.action = this.requiredAction(fSATransition.getLabel());
        if (this.action == 0) {
            JOptionPane.showMessageDialog(this.convertPane, "That's as good as it gets.", "No Action Necessary", 0);
            return;
        }
        this.transition = fSATransition;
        this.toDo.remove(fSATransition);
        String string = fSATransition.getLabel();
        switch (this.action) {
            case 1: {
                State state = fSATransition.getFromState();
                State state2 = fSATransition.getToState();
                String string2 = Discretizer.delambda(string.substring(1, string.length() - 1));
                this.automaton.removeTransition(fSATransition);
                FSATransition fSATransition2 = new FSATransition(state, state2, string2);
                this.automaton.addTransition(fSATransition2);
                if (this.requiredAction(string2) != 0) {
                    this.toDo.add(fSATransition2);
                }
                this.action = 0;
                break;
            }
            case 2: {
                this.replacements = this.replaceTransition(fSATransition, new String[]{Discretizer.delambda(string.substring(0, string.length() - 1))});
                this.transitionNeeded = 4;
                break;
            }
            case 3: {
                this.replacements = this.replaceTransition(fSATransition, Discretizer.or(string));
                this.transitionNeeded = 2 * this.replacements.length;
                break;
            }
            case 4: {
                this.replacements = this.replaceTransition(fSATransition, Discretizer.cat(string));
                this.transitionNeeded = this.replacements.length + 1;
                this.catEndMade = false;
                this.catBeginMade = false;
            }
        }
        this.nextStep();
    }

    private FSATransition lambda(State state, State state2) {
        return new FSATransition(state, state2, "");
    }

    public void completeStep() {
        Serializable serializable;
        Object object;
        if (this.action == 0) {
            object = this.toDo.iterator();
            serializable = (FSATransition)object.next();
            this.transitionCheck((FSATransition)serializable);
        }
        object = this.transition.getFromState();
        serializable = this.transition.getToState();
        switch (this.action) {
            case 1: {
                return;
            }
            case 3: {
                for (int i = 0; i < this.replacements.length; ++i) {
                    this.automaton.addTransition(this.lambda((State)object, this.replacements[i].getFromState()));
                    this.automaton.addTransition(this.lambda(this.replacements[i].getToState(), (State)serializable));
                }
                break;
            }
            case 4: {
                this.automaton.addTransition(this.lambda((State)object, this.replacements[0].getFromState()));
                for (int i = 0; i < this.replacements.length - 1; ++i) {
                    this.automaton.addTransition(this.lambda(this.replacements[i].getToState(), this.replacements[i + 1].getFromState()));
                }
                this.automaton.addTransition(this.lambda(this.replacements[this.replacements.length - 1].getToState(), (State)serializable));
                break;
            }
            case 2: {
                this.automaton.addTransition(this.lambda((State)object, this.replacements[0].getFromState()));
                this.automaton.addTransition(this.lambda(this.replacements[0].getToState(), (State)serializable));
                this.automaton.addTransition(this.lambda((State)object, (State)serializable));
                this.automaton.addTransition(this.lambda((State)serializable, (State)object));
            }
        }
        this.transitionNeeded = 0;
        this.nextStep();
    }

    public void completeAll() {
        while (this.action != 0 || this.toDo.size() > 0) {
            this.completeStep();
        }
    }

    public void export() {
        FrameFactory.createFrame((FiniteStateAutomaton)this.automaton.clone());
    }

    public void exportToTab() {
        AutomatonPane automatonPane = new AutomatonPane(this.automaton);
        this.convertPane.environment.add((Component)automatonPane, "Current FA");
        this.convertPane.environment.setActive(automatonPane);
    }

    public void transitionCreate(State state, State state2) {
        boolean bl = this.automaton.getTransitionsFromStateToState(state, state2).length != 0;
        boolean bl2 = false;
        block0 : switch (this.action) {
            case 0: {
                JOptionPane.showMessageDialog(this.convertPane, "A transition must be selected with\nthe deexpressionifier tool first.", "Invalid Action", 0);
                return;
            }
            case 3: {
                int n2;
                if (state == this.transition.getFromState()) {
                    for (n2 = 0; n2 < this.replacements.length; ++n2) {
                        if (this.replacements[n2].getFromState() != state2) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (state2 != this.transition.getToState()) break;
                for (n2 = 0; n2 < this.replacements.length; ++n2) {
                    if (this.replacements[n2].getToState() != state) continue;
                    bl2 = true;
                    break block0;
                }
                break;
            }
            case 4: {
                int n;
                if (this.automaton.getTransitionsFromState(state).length > 0 || this.automaton.getTransitionsToState(state2).length > 0) {
                    if (!bl) break;
                    bl2 = true;
                    break;
                }
                int n2 = -1;
                int n3 = -1;
                for (n = 0; n < this.replacements.length; ++n) {
                    if (this.replacements[n].getToState() == state) {
                        n2 = n;
                    }
                    if (this.replacements[n].getFromState() != state2) continue;
                    n3 = n;
                }
                n = this.replacements.length + 1 - this.transitionNeeded;
                if (n2 == -1 && state != this.transition.getFromState() || n3 == -1 && state2 != this.transition.getToState()) break;
                if (n3 == -1) {
                    if (n != this.replacements.length) {
                        JOptionPane.showMessageDialog(this.convertPane, "That may be correct, but the transitions\nmust be connected in order.", "Out of Order", 0);
                        return;
                    }
                    bl2 = state == this.replacements[this.replacements.length - 1].getToState();
                    break;
                }
                if (n == 0 && n2 != -1 || n > 0 && this.replacements[n - 1].getToState() != state) {
                    JOptionPane.showMessageDialog(this.convertPane, "That may be correct, but the transitions\nmust be connected in order.", "Out of Order", 0);
                    return;
                }
                if (this.replacements[n3].getLabel().equals(this.replacements[n].getLabel())) {
                    FSATransition fSATransition = this.replacements[n];
                    this.replacements[n] = this.replacements[n3];
                    this.replacements[n3] = fSATransition;
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            case 2: {
                if (state2 == this.transition.getToState() && state == this.transition.getFromState()) {
                    bl2 = true;
                    break;
                }
                if (state == this.transition.getToState() && state2 == this.transition.getFromState()) {
                    bl2 = true;
                    break;
                }
                if (state2 == this.transition.getToState() && state == this.replacements[0].getToState()) {
                    bl2 = true;
                    break;
                }
                if (state != this.transition.getFromState() || state2 != this.replacements[0].getFromState()) break;
                bl2 = true;
            }
        }
        if (!bl2) {
            JOptionPane.showMessageDialog(this.convertPane, "A transition there is invalid.", "Bad Transition", 0);
            return;
        }
        if (bl) {
            JOptionPane.showMessageDialog(this.convertPane, "A transition exists here.", "Transition Already Exists", 0);
            return;
        }
        FSATransition fSATransition = new FSATransition(state, state2, "");
        this.automaton.addTransition(fSATransition);
        --this.transitionNeeded;
        this.nextStep();
    }

    private void nextStep() {
        if (this.transitionNeeded == 0) {
            if (this.toDo.size() > 0) {
                if (this.action != 0) {
                    this.convertPane.mainLabel.setText("Resolution complete.");
                } else {
                    this.convertPane.mainLabel.setText("Welcome to the converter.");
                }
                this.convertPane.detailLabel.setText(this.toDo.size() + " more resolutions needed.");
                this.action = 0;
                return;
            }
            this.action = 0;
            this.convertPane.mainLabel.setText("The automaton is complete.");
            this.convertPane.detailLabel.setText("\"Export\" will put it in a new window.");
            this.convertPane.exportAction.setEnabled(true);
            this.convertPane.doStepAction.setEnabled(false);
            this.convertPane.doAllAction.setEnabled(false);
            return;
        }
        this.convertPane.detailLabel.setText(this.transitionNeeded + " more " + Universe.curProfile.getEmptyString() + "-transitions needed.");
        switch (this.action) {
            case 3: {
                this.convertPane.mainLabel.setText("De-oring " + this.transition.getLabel());
                break;
            }
            case 4: {
                this.convertPane.mainLabel.setText("De-concatenating " + this.transition.getLabel());
                break;
            }
            case 2: {
                this.convertPane.mainLabel.setText("De-staring " + this.transition.getLabel());
            }
        }
    }
}

