/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.State;
import automata.Transition;
import automata.fsa.FSAToRegularExpressionConverter;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.FrameFactory;
import gui.environment.Universe;
import gui.regular.TransitionWindow;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import regular.RegularExpression;

public class FSAToREController {
    private int currentStep = -1;
    private FiniteStateAutomaton automaton;
    private SelectionDrawer drawer;
    private JLabel mainStep;
    private JLabel detailStep;
    private JFrame frame;
    private int remaining = 0;
    private TransitionWindow transitionWindow = null;
    private State collapseState = null;
    private String computedRE = null;
    private static final int CREATE_SINGLE_FINAL = 0;
    private static final int TRANSITIONS_TO_SINGLE_FINAL = 1;
    private static final int CONVERT_TRANSITIONS = 2;
    private static final int CREATE_EMPTY_TRANSITIONS = 3;
    private static final int COLLAPSE_STATES = 4;
    private static final int FINISHED = 200;

    public FSAToREController(FiniteStateAutomaton finiteStateAutomaton, SelectionDrawer selectionDrawer, JLabel jLabel, JLabel jLabel2, JFrame jFrame) {
        this.automaton = finiteStateAutomaton;
        this.drawer = selectionDrawer;
        this.mainStep = jLabel;
        this.detailStep = jLabel2;
        this.frame = jFrame;
        this.nextStep();
    }

    protected void outOfOrder() {
        JOptionPane.showMessageDialog(this.frame, "That action is inappropriate for this step!", "Out of Order", 0);
    }

    protected void nextStep() {
        switch (this.currentStep) {
            case -1: 
            case 0: {
                this.currentStep = 0;
                this.mainStep.setText("Make Single Noninitial Final State");
                this.detailStep.setText("Create a new state to make a single final state.");
                if (this.automaton.getFinalStates().length != 1 || this.automaton.getFinalStates()[0] == this.automaton.getInitialState()) {
                    return;
                }
                this.currentStep = 1;
            }
            case 1: {
                this.detailStep.setText("Put " + Universe.curProfile.getEmptyString() + "-transitions from old final states to new.");
                if (this.drawer.numberSelected() != 0) {
                    return;
                }
                this.currentStep = 2;
                this.remaining = this.collapsesNeeded();
            }
            case 2: {
                this.mainStep.setText("Reform Transitions");
                this.detailStep.setText("Use the collapse tool to turn multiple transitions to one. " + this.remaining + " more collapses needed.");
                if (this.remaining != 0) {
                    return;
                }
                this.currentStep = 3;
                this.remaining = this.emptyNeeded();
            }
            case 3: {
                this.detailStep.setText("Put empty transitions between states with no transitions. " + this.remaining + " more empty transitions needed.");
                if (this.remaining != 0) {
                    return;
                }
                this.remaining = this.automaton.getStates().length - 2;
                this.currentStep = 4;
            }
            case 4: {
                this.mainStep.setText("Remove States");
                this.detailStep.setText("Use the collapse state tool to remove nonfinal, noninitial states. " + this.remaining + " more removals needed.");
                if (this.remaining != 0) {
                    return;
                }
                if (this.transitionWindow != null) {
                    this.transitionWindow.setVisible(false);
                    this.transitionWindow.dispose();
                }
                this.drawer.clearSelected();
                this.drawer.clearSelectedTransitions();
                this.currentStep = 200;
            }
            case 200: {
                this.mainStep.setText("Generalized Transition Graph Finished!");
                this.computedRE = FSAToRegularExpressionConverter.getExpressionFromGTG(this.automaton);
                this.detailStep.setText(this.computedRE);
            }
        }
    }

    protected int collapsesNeeded() {
        State[] stateArray = this.automaton.getStates();
        int n = 0;
        for (int i = 0; i < stateArray.length; ++i) {
            for (int j = 0; j < stateArray.length; ++j) {
                if (this.automaton.getTransitionsFromStateToState(stateArray[i], stateArray[j]).length <= 1) continue;
                ++n;
            }
        }
        return n;
    }

    protected int emptyNeeded() {
        State[] stateArray = this.automaton.getStates();
        int n = 0;
        for (int i = 0; i < stateArray.length; ++i) {
            for (int j = 0; j < stateArray.length; ++j) {
                if (this.automaton.getTransitionsFromStateToState(stateArray[i], stateArray[j]).length != 0) continue;
                ++n;
            }
        }
        return n;
    }

    public State stateCreate(Point point) {
        if (this.currentStep != 0) {
            this.outOfOrder();
            return null;
        }
        State[] stateArray = this.automaton.getFinalStates();
        this.drawer.clearSelected();
        for (int i = 0; i < stateArray.length; ++i) {
            this.automaton.removeFinalState(stateArray[i]);
            this.drawer.addSelected(stateArray[i]);
        }
        State state = this.automaton.createState(point);
        this.automaton.addFinalState(state);
        this.frame.repaint();
        this.nextStep();
        return state;
    }

    public Transition transitionCreate(State state, State state2) {
        if (this.currentStep == 1) {
            if (this.automaton.getFinalStates()[0] != state2) {
                JOptionPane.showMessageDialog(this.frame, "Transitions must go to the new final state!", "Bad Destination", 0);
                return null;
            }
            if (!this.drawer.isSelected(state)) {
                JOptionPane.showMessageDialog(this.frame, "Transitions must come from an old final state!", "Bad Source", 0);
                return null;
            }
            FSATransition fSATransition = new FSATransition(state, state2, "");
            this.drawer.removeSelected(state);
            this.automaton.addTransition(fSATransition);
            this.frame.repaint();
            if (this.drawer.numberSelected() == 0) {
                this.nextStep();
            }
            return fSATransition;
        }
        if (this.currentStep == 3) {
            if (this.automaton.getTransitionsFromStateToState(state, state2).length != 0) {
                JOptionPane.showMessageDialog(this.frame, "Transitions must go betweenstates with no transitions!", "Transition Already Exists", 0);
                return null;
            }
            FSATransition fSATransition = FSAToRegularExpressionConverter.addTransitionOnEmptySet(state, state2, this.automaton);
            --this.remaining;
            this.nextStep();
            this.frame.repaint();
            return fSATransition;
        }
        this.outOfOrder();
        return null;
    }

    public Transition transitionCollapse(State state, State state2) {
        if (this.currentStep != 2) {
            this.outOfOrder();
            return null;
        }
        Transition[] transitionArray = this.automaton.getTransitionsFromStateToState(state, state2);
        if (transitionArray.length <= 1) {
            JOptionPane.showMessageDialog(this.frame, "Collapse requires 2 or more transitions!", "Too Few Transitions", 0);
            return null;
        }
        FSATransition fSATransition = FSAToRegularExpressionConverter.combineToSingleTransition(state, state2, transitionArray, this.automaton);
        --this.remaining;
        this.frame.repaint();
        this.nextStep();
        return fSATransition;
    }

    public boolean stateCollapse(State state) {
        if (this.currentStep != 4) {
            this.outOfOrder();
            return false;
        }
        if (this.automaton.getInitialState() == state) {
            JOptionPane.showMessageDialog(this.frame, "The initial state cannot be removed!", "Initial State Selected", 0);
            return false;
        }
        if (this.automaton.getFinalStates()[0] == state) {
            JOptionPane.showMessageDialog(this.frame, "The final state cannot be removed!", "Final State Selected", 0);
            return false;
        }
        this.collapseState = state;
        this.drawer.clearSelected();
        this.drawer.addSelected(this.collapseState);
        this.transitionWindow = new TransitionWindow(this);
        this.transitionWindow.setTransitions(FSAToRegularExpressionConverter.getTransitionsForRemoveState(state, this.automaton));
        this.transitionWindow.setVisible(true);
        return true;
    }

    public void finalizeStateRemove() {
        if (this.collapseState == null) {
            JOptionPane.showMessageDialog(this.frame, "A valid state has not been selected yet!", "No State Selected", 0);
            return;
        }
        FSAToRegularExpressionConverter.removeState(this.collapseState, this.transitionWindow.getTransitions(), this.automaton);
        --this.remaining;
        this.nextStep();
        this.collapseState = null;
        this.drawer.clearSelected();
        this.drawer.clearSelectedTransitions();
        this.transitionWindow.setVisible(false);
        this.transitionWindow.dispose();
    }

    public void tableTransitionSelected(Transition transition) {
        this.drawer.clearSelectedTransitions();
        if (transition == null || this.collapseState == null) {
            return;
        }
        State state = transition.getFromState();
        State state2 = transition.getToState();
        Transition transition2 = this.automaton.getTransitionsFromStateToState(state, this.collapseState)[0];
        Transition transition3 = this.automaton.getTransitionsFromStateToState(state, state2)[0];
        Transition transition4 = this.automaton.getTransitionsFromStateToState(this.collapseState, this.collapseState)[0];
        Transition transition5 = this.automaton.getTransitionsFromStateToState(this.collapseState, state2)[0];
        this.drawer.addSelected(transition2);
        this.drawer.addSelected(transition3);
        this.drawer.addSelected(transition4);
        this.drawer.addSelected(transition5);
        this.frame.repaint();
    }

    public void moveNextStep() {
        switch (this.currentStep) {
            case 0: {
                JOptionPane.showMessageDialog(this.frame, "Just create a state.\nIt's not too difficult.", "Create the State", 0);
                return;
            }
            case 1: {
                State[] stateArray = this.drawer.getSelected();
                State state = this.automaton.getFinalStates()[0];
                for (int i = 0; i < stateArray.length; ++i) {
                    this.transitionCreate(stateArray[i], state);
                }
                break;
            }
            case 2: {
                State[] stateArray = this.automaton.getStates();
                for (int i = 0; i < stateArray.length; ++i) {
                    for (int j = 0; j < stateArray.length; ++j) {
                        if (this.automaton.getTransitionsFromStateToState(stateArray[i], stateArray[j]).length <= 1) continue;
                        this.transitionCollapse(stateArray[i], stateArray[j]);
                    }
                }
                break;
            }
            case 3: {
                State[] stateArray = this.automaton.getStates();
                for (int i = 0; i < stateArray.length; ++i) {
                    for (int j = 0; j < stateArray.length; ++j) {
                        if (this.automaton.getTransitionsFromStateToState(stateArray[i], stateArray[j]).length != 0) continue;
                        this.transitionCreate(stateArray[i], stateArray[j]);
                    }
                }
                break;
            }
            case 4: {
                State[] stateArray = this.automaton.getStates();
                for (int i = 0; i < stateArray.length; ++i) {
                    if (this.automaton.getFinalStates()[0] == stateArray[i] || this.automaton.getInitialState() == stateArray[i]) continue;
                    Transition[] transitionArray = FSAToRegularExpressionConverter.getTransitionsForRemoveState(stateArray[i], this.automaton);
                    FSAToRegularExpressionConverter.removeState(stateArray[i], transitionArray, this.automaton);
                }
                this.remaining = 0;
                this.nextStep();
                break;
            }
            case 200: {
                JOptionPane.showMessageDialog(this.frame, "You're done.  Go away.", "You're Done!", 0);
                return;
            }
            default: {
                JOptionPane.showMessageDialog(this.frame, "This shouldn't happen!  Notify Thomas.", "Uh Oh, I'm Stupid!", 0);
            }
        }
    }

    public void export() {
        if (this.computedRE == null) {
            JOptionPane.showMessageDialog(this.frame, "The conversion has not yet finished.", "Not Finished", 0);
            return;
        }
        FrameFactory.createFrame(new RegularExpression(this.computedRE));
    }

    void exportAutomaton() {
        Environment environment = ((EnvironmentFrame)this.frame).getEnvironment();
        AutomatonPane automatonPane = new AutomatonPane(this.drawer);
        environment.add((Component)automatonPane, "Current FA");
        environment.setActive(automatonPane);
    }
}

