/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.State;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBar;
import gui.editor.ToolBox;
import gui.environment.EnvironmentFrame;
import gui.environment.RegularEnvironment;
import gui.environment.Universe;
import gui.regular.DeexpressionifyTransitionTool;
import gui.regular.REToFSAController;
import gui.regular.RegularToAutomatonTransitionTool;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import regular.Discretizer;

public class ConvertToAutomatonPane
extends JPanel {
    RegularEnvironment environment;
    private FiniteStateAutomaton automaton = new FiniteStateAutomaton();
    private REToFSAController controller;
    JFrame frame;
    JLabel mainLabel = new JLabel();
    JLabel detailLabel = new JLabel();
    AbstractAction doStepAction = new AbstractAction("Do Step"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConvertToAutomatonPane.this.controller.completeStep();
        }
    };
    AbstractAction doAllAction = new AbstractAction("Do All"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConvertToAutomatonPane.this.controller.completeAll();
        }
    };
    AbstractAction exportAction = new AbstractAction("Export"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConvertToAutomatonPane.this.controller.export();
        }
    };
    AbstractAction exportAction2 = new AbstractAction("Export Now"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConvertToAutomatonPane.this.controller.exportToTab();
        }
    };

    public ConvertToAutomatonPane(RegularEnvironment regularEnvironment) {
        this.environment = regularEnvironment;
        EnvironmentFrame environmentFrame = Universe.frameForEnvironment(regularEnvironment);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.mainLabel, "North");
        jPanel.add((Component)this.detailLabel, "South");
        this.mainLabel.setText(" ");
        this.detailLabel.setText(" ");
        this.add((Component)jPanel, "North");
        SelectionDrawer selectionDrawer = new SelectionDrawer(this.automaton);
        State state = this.automaton.createState(new Point(60, 40));
        State state2 = this.automaton.createState(new Point(450, 250));
        this.automaton.setInitialState(state);
        this.automaton.addFinalState(state2);
        FSATransition fSATransition = new FSATransition(state, state2, Discretizer.delambda(regularEnvironment.getExpression().asString().replace('!', Universe.curProfile.getEmptyString().charAt(0))));
        this.automaton.addTransition(fSATransition);
        this.controller = new REToFSAController(this, this.automaton);
        EditorPane editorPane = new EditorPane(selectionDrawer, new ToolBox(){

            @Override
            public List tools(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
                LinkedList<Tool> linkedList = new LinkedList<Tool>();
                linkedList.add(new ArrowNontransitionTool(automatonPane, automatonDrawer));
                linkedList.add(new RegularToAutomatonTransitionTool(automatonPane, automatonDrawer, ConvertToAutomatonPane.this.controller));
                linkedList.add(new DeexpressionifyTransitionTool(automatonPane, automatonDrawer, ConvertToAutomatonPane.this.controller));
                return linkedList;
            }
        });
        ToolBar toolBar = editorPane.getToolBar();
        toolBar.addSeparator();
        toolBar.add(this.doStepAction);
        toolBar.add(this.doAllAction);
        toolBar.add(this.exportAction);
        this.add((Component)editorPane, "Center");
    }
}

