/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.Transition;
import gui.editor.Tool;
import gui.regular.FSAToREController;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class CollapseTool
extends Tool {
    private FSAToREController controller;

    public CollapseTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer, FSAToREController fSAToREController) {
        super(automatonPane, automatonDrawer);
        this.controller = fSAToREController;
    }

    @Override
    public String getToolTip() {
        return "Transition Collapser";
    }

    @Override
    protected Icon getIcon() {
        URL uRL = this.getClass().getResource("/ICON/collapse.gif");
        return new ImageIcon(uRL);
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('c');
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Transition transition = this.getDrawer().transitionAtPoint(mouseEvent.getPoint());
        if (transition != null) {
            this.controller.transitionCollapse(transition.getFromState(), transition.getToState());
        }
    }
}

