/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.HumanFirstPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderPanel
extends JPanel {
    private static int START_MAX = 10;
    private HumanFirstPane myPane;
    private JTextArea myDisplay;
    private JTextArea myLengthDisplay;
    private JSlider mySlider;
    private int myMin;
    private int myMax;
    private String myText;

    public SliderPanel(String string, HumanFirstPane humanFirstPane) {
        super(new BorderLayout());
        this.myPane = humanFirstPane;
        this.myDisplay = new JTextArea(1, 30);
        this.myDisplay.setEditable(false);
        this.myLengthDisplay = new JTextArea(1, 5);
        this.myLengthDisplay.setEditable(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 7));
        jPanel.add(new JLabel(string + ": "));
        jPanel.add(this.myDisplay);
        jPanel.add(new JLabel("    |" + string + "|: "));
        jPanel.add(this.myLengthDisplay);
        this.add((Component)jPanel, "Center");
        this.mySlider = new JSlider(0, START_MAX);
        this.mySlider.setValue(0);
        this.mySlider.setPaintTicks(true);
        this.mySlider.setMinorTickSpacing(1);
        this.mySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SliderPanel.this.refresh();
                SliderPanel.this.myPane.refresh();
            }
        });
        this.add((Component)this.mySlider, "South");
        this.myMin = 0;
        this.myMax = 0;
        this.myText = "";
    }

    public void setRange(int n, int n2) {
        this.myMax = n2;
        this.setMin(n);
    }

    public void setMin(int n) {
        this.myMin = n;
        this.refresh();
    }

    public void setSliderMax(int n) {
        this.mySlider.setMaximum(n);
    }

    public void setVal(int n) {
        this.mySlider.setValue(n);
        this.refresh();
    }

    public void setText(String string) {
        this.myText = string;
        this.refresh();
    }

    public void refresh() {
        try {
            int n = this.mySlider.getValue();
            if (n > this.myMax) {
                n = this.myMax;
            }
            if (this.mySlider.getValue() < this.myMin) {
                this.mySlider.setValue(this.myMin);
            }
            this.myDisplay.setText(this.myText.substring(this.myMin, n));
            this.myLengthDisplay.setText("" + (this.mySlider.getValue() - this.myMin));
            this.repaint();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int getVal() {
        return this.mySlider.getValue();
    }

    public void reset() {
        this.mySlider.setMaximum(START_MAX);
        this.setVal(0);
        this.setText("");
        this.myLengthDisplay.setText("");
    }
}

