/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.HumanFirstPane;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import pumping.RegularPumpingLemma;

public class HumanRegPumpingLemmaInputPane
extends HumanFirstPane {
    private static String I_WIN = "I WIN. Do you want to play again or concede that the language is not regular?";
    private static String YOU_WIN = "YOU WIN. Does this mean the language is regular?";
    private static String PROMPT_DECOMPOSITION = "Please select the decomposition of w into xyz using the sliders.";

    public HumanRegPumpingLemmaInputPane(RegularPumpingLemma regularPumpingLemma) {
        super(regularPumpingLemma, "<i>L</i> = {" + regularPumpingLemma.getHTMLTitle() + "} Regular Pumping Lemma");
    }

    @Override
    protected void addDecompPanelGameFeatures(JPanel jPanel) {
        jPanel.setMaximumSize(new Dimension(HumanRegPumpingLemmaInputPane.MAX_SIZE.width, 3 * HumanRegPumpingLemmaInputPane.MAX_SIZE.height / 10));
        jPanel.setPreferredSize(new Dimension(HumanRegPumpingLemmaInputPane.MAX_SIZE.width, 3 * HumanRegPumpingLemmaInputPane.MAX_SIZE.height / 10));
        this.decompButtonTitle = new String("Set xyz");
        jPanel.setBorder(BorderFactory.createTitledBorder("3. Select decomposition of w into xyz."));
    }

    @Override
    protected void mEnteredReset() {
        String string = this.myLemma.getW();
        this.myWDisplay.setText(string);
        this.myXPanel.setSliderMax(string.length());
        this.myXPanel.setVal(0);
        this.myXPanel.setText(this.myLemma.getW());
        this.myYPanel.setSliderMax(string.length());
        this.myYPanel.setVal(0);
        this.myYPanel.setText(this.myLemma.getW());
        this.refresh();
        this.updateTable();
        this.leftPanel.revalidate();
    }

    @Override
    protected void resetDecompPanel() {
        this.myXPanel.reset();
        this.myYPanel.reset();
        this.myZDisplay.setText("");
        this.myZLength.setText("");
        this.updateTable();
    }

    @Override
    protected void refresh() {
        try {
            this.myXPanel.setRange(0, this.myYPanel.getVal() - 1);
            this.myYPanel.setRange(this.myXPanel.getVal(), this.myLemma.getM());
            this.myZDisplay.setText(this.myLemma.getW().substring(this.myYPanel.getVal()));
            this.myZLength.setText(Integer.toString(this.myZDisplay.getText().length()));
            this.myIDisplay.setText("");
            this.myPumpedStringDisplay.setText("");
            this.myLastWord.setText("");
            this.myCanvas.reset();
            if (this.myXPanel.getVal() >= this.myYPanel.getVal()) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |y| > 0");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else if (this.myYPanel.getVal() > this.myLemma.getM()) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |xy| <= m");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else {
                this.stageMessages[3].setText("Click \"Set xyz\" to set decomposition.");
                this.myDecompButton.setEnabled(true);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void setDecomposition(int[] nArray) {
        this.myXPanel.setVal(nArray[0]);
        this.myYPanel.setVal(nArray[0] + nArray[1]);
    }

    @Override
    protected void setI() {
        int[] nArray = new int[]{this.myXPanel.getVal(), this.myYPanel.getVal() - this.myXPanel.getVal()};
        this.myLemma.setDecomposition(nArray);
        this.myLemma.chooseI();
        if (this.myCases != null) {
            this.myCases.setDecomposition(nArray);
            this.myCases.setI(this.myLemma.getI());
        }
    }

    @Override
    protected void setCanvas() {
        this.stages[5].setVisible(true);
        this.myCanvas.reset();
        this.myCanvas.addText("w =");
        this.myCanvas.addText(((RegularPumpingLemma)this.myLemma).getX(), "x");
        this.myCanvas.addText(((RegularPumpingLemma)this.myLemma).getY(), "y");
        this.myCanvas.addText(((RegularPumpingLemma)this.myLemma).getZ(), "z");
        this.myCanvas.moveText(new int[]{0, 1, this.myLemma.getI(), 1});
        this.myStepAnimation.setEnabled(true);
        this.myStartAnimation.setEnabled(false);
        this.repaint();
    }

    @Override
    protected String createXYZ() {
        return "<i>xy</i><sup>" + this.myLemma.getI() + "</sup><i>z</i>";
    }

    @Override
    public void update() {
        RegularPumpingLemma regularPumpingLemma = (RegularPumpingLemma)this.myLemma;
        this.stageMessages[0].setText("File loaded.");
        this.updateTopPane(false);
        if (regularPumpingLemma.getM() == -1) {
            return;
        }
        this.myMDisplay.setText("" + regularPumpingLemma.getM());
        this.myWDisplay.setText(regularPumpingLemma.getW());
        this.myXPanel.setText(regularPumpingLemma.getW());
        this.myXPanel.setSliderMax(regularPumpingLemma.getW().length());
        this.myYPanel.setText(regularPumpingLemma.getW());
        this.myYPanel.setSliderMax(regularPumpingLemma.getW().length());
        this.setDecomposition(new int[]{regularPumpingLemma.getX().length(), regularPumpingLemma.getY().length()}, regularPumpingLemma.getI());
        this.updateTable();
        this.stages[2].setVisible(true);
        this.stages[3].setVisible(true);
        if (regularPumpingLemma.getX().length() == 0 && regularPumpingLemma.getY().length() == 0) {
            this.myDecompButton.setEnabled(false);
        } else {
            this.stages[4].setVisible(true);
            this.stages[5].setVisible(true);
            this.stageMessages[5].setText("Click \"Restart\" to restart the animation.");
            this.stageMessages[5].setVisible(true);
            this.displayIEnd();
            this.myCanvas.setRestartEnabled(true);
        }
    }
}

