/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.HumanFirstPane;
import gui.pumping.SliderPanel;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import pumping.ContextFreePumpingLemma;

public class HumanCFPumpingLemmaInputPane
extends HumanFirstPane {
    private static String I_WIN = "I WIN. Do you want to play again or concede that the language is not context-free?";
    private static String YOU_WIN = "YOU WIN. Does this mean the language is context-free?";
    private SliderPanel myUPanel;
    private SliderPanel myVPanel;

    public HumanCFPumpingLemmaInputPane(ContextFreePumpingLemma contextFreePumpingLemma) {
        super(contextFreePumpingLemma, "<i>L</i> = {" + contextFreePumpingLemma.getHTMLTitle() + "} Context-Free Pumping Lemma");
    }

    @Override
    protected void addDecompPanelGameFeatures(JPanel jPanel) {
        this.decompButtonTitle = new String("Set uvxyz");
        jPanel.setMaximumSize(new Dimension(HumanCFPumpingLemmaInputPane.MAX_SIZE.width, 9 * HumanCFPumpingLemmaInputPane.MAX_SIZE.height / 20));
        jPanel.setPreferredSize(new Dimension(HumanCFPumpingLemmaInputPane.MAX_SIZE.width, 9 * HumanCFPumpingLemmaInputPane.MAX_SIZE.height / 20));
        this.myUPanel = new SliderPanel("u", this);
        this.sliderPanel.add(this.myUPanel);
        this.myVPanel = new SliderPanel("v", this);
        this.sliderPanel.add(this.myVPanel);
        jPanel.setBorder(BorderFactory.createTitledBorder("3. Select decomposition of w into uvxyz."));
    }

    @Override
    protected void mEnteredReset() {
        String string = this.myLemma.getW();
        this.myWDisplay.setText(string);
        this.myUPanel.setSliderMax(string.length());
        this.myUPanel.setText(string);
        this.myUPanel.setVal(0);
        this.myVPanel.setSliderMax(string.length());
        this.myVPanel.setText(string);
        this.myVPanel.setVal(0);
        this.myXPanel.setSliderMax(string.length());
        this.myXPanel.setText(string);
        this.myXPanel.setVal(0);
        this.myYPanel.setSliderMax(string.length());
        this.myYPanel.setText(string);
        this.myYPanel.setVal(0);
        this.refresh();
        this.updateTable();
        this.leftPanel.revalidate();
    }

    @Override
    protected void resetDecompPanel() {
        this.myUPanel.reset();
        this.myVPanel.reset();
        this.myXPanel.reset();
        this.myYPanel.reset();
        this.myZDisplay.setText("");
        this.myZLength.setText("");
        this.updateTable();
    }

    @Override
    protected void refresh() {
        try {
            this.myUPanel.setRange(0, this.myVPanel.getVal());
            this.myVPanel.setRange(this.myUPanel.getVal(), this.myXPanel.getVal());
            this.myXPanel.setRange(this.myVPanel.getVal(), this.myYPanel.getVal());
            this.myYPanel.setRange(this.myXPanel.getVal(), this.myLemma.getW().length());
            this.myZDisplay.setText(this.myLemma.getW().substring(this.myYPanel.getVal()));
            this.myZLength.setText(Integer.toString(this.myZDisplay.getText().length()));
            this.myIDisplay.setText("");
            this.myPumpedStringDisplay.setText("");
            this.myLastWord.setText("");
            this.myCanvas.reset();
            if (this.myUPanel.getVal() > this.myVPanel.getVal()) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |v| >= 0");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else if (this.myVPanel.getVal() > this.myXPanel.getVal()) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |x| >= 0");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else if (this.myXPanel.getVal() > this.myYPanel.getVal()) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |y| >= 0");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else if (this.myYPanel.getVal() - this.myUPanel.getVal() > this.myLemma.getM()) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |vxy| <= m");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else if (this.myVPanel.getVal() - this.myUPanel.getVal() + (this.myYPanel.getVal() - this.myXPanel.getVal()) < 1) {
                this.myZDisplay.setText("");
                this.stageMessages[3].setText("Condition violated: |vy| >= 1");
                this.myZLength.setText("");
                this.myDecompButton.setEnabled(false);
            } else {
                this.stageMessages[3].setText("Click \"Set uvxyz\" to set decomposition.");
                this.myDecompButton.setEnabled(true);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void setDecomposition(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        this.myUPanel.setVal(n);
        this.myVPanel.setVal(n + n2);
        this.myXPanel.setVal(n + n2 + n3);
        this.myYPanel.setVal(n + n2 + n3 + n4);
        this.myLemma.setDecomposition(nArray);
    }

    @Override
    protected void setI() {
        int[] nArray = new int[]{this.myUPanel.getVal(), this.myVPanel.getVal() - this.myUPanel.getVal(), this.myXPanel.getVal() - this.myVPanel.getVal(), this.myYPanel.getVal() - this.myXPanel.getVal(), this.myLemma.getW().length() - this.myYPanel.getVal()};
        this.myLemma.setDecomposition(nArray);
        this.myLemma.chooseI();
        if (this.myCases != null) {
            this.myCases.setDecomposition(nArray);
            this.myCases.setI(this.myLemma.getI());
        }
    }

    @Override
    protected void setCanvas() {
        this.stages[5].setVisible(true);
        this.myCanvas.reset();
        this.myCanvas.addText("w =");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getU(), "u");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getV(), "v");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getX(), "x");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getY(), "y");
        this.myCanvas.addText(((ContextFreePumpingLemma)this.myLemma).getZ(), "z");
        this.myCanvas.moveText(new int[]{0, 1, this.myLemma.getI(), 1, this.myLemma.getI(), 1});
        this.myStepAnimation.setEnabled(true);
        this.myStartAnimation.setEnabled(false);
        this.repaint();
    }

    @Override
    protected String createXYZ() {
        return "<i>uv</i><sup>" + this.myLemma.getI() + "</sup><i>xy</i><sup>" + this.myLemma.getI() + "</sup><i>z</i>";
    }

    @Override
    public void update() {
        ContextFreePumpingLemma contextFreePumpingLemma = (ContextFreePumpingLemma)this.myLemma;
        this.stageMessages[0].setText("File loaded.");
        this.updateTopPane(false);
        if (contextFreePumpingLemma.getM() == -1) {
            return;
        }
        this.myMDisplay.setText("" + contextFreePumpingLemma.getM());
        this.myWDisplay.setText(contextFreePumpingLemma.getW());
        int[] nArray = new int[]{contextFreePumpingLemma.getU().length(), contextFreePumpingLemma.getV().length(), contextFreePumpingLemma.getX().length(), contextFreePumpingLemma.getY().length()};
        this.myUPanel.setText(contextFreePumpingLemma.getW());
        this.myUPanel.setSliderMax(contextFreePumpingLemma.getW().length());
        this.myVPanel.setText(contextFreePumpingLemma.getW());
        this.myVPanel.setSliderMax(contextFreePumpingLemma.getW().length());
        this.myXPanel.setText(contextFreePumpingLemma.getW());
        this.myXPanel.setSliderMax(contextFreePumpingLemma.getW().length());
        this.myYPanel.setText(contextFreePumpingLemma.getW());
        this.myYPanel.setSliderMax(contextFreePumpingLemma.getW().length());
        this.setDecomposition(nArray, contextFreePumpingLemma.getI());
        if (this.myCases != null) {
            this.myCases.setDecomposition(nArray);
            this.myCases.setListButtonEnabled(true);
        }
        this.updateTable();
        this.stages[2].setVisible(true);
        this.stages[3].setVisible(true);
        if (contextFreePumpingLemma.getU().length() == 0 && contextFreePumpingLemma.getV().length() == 0 && contextFreePumpingLemma.getX().length() == 0 && contextFreePumpingLemma.getY().length() == 0) {
            this.myDecompButton.setEnabled(false);
        } else {
            this.stages[4].setVisible(true);
            this.stages[5].setVisible(true);
            this.stageMessages[5].setText("Click \"Restart\" to restart the animation.");
            this.stageMessages[5].setVisible(true);
            if (this.myCases != null) {
                this.myCases.setAddReplaceButtonsEnabled(true);
            }
            this.displayIEnd();
            this.myCanvas.setRestartEnabled(true);
        }
    }
}

