/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.PumpingLemmaInputPane;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pumping.PumpingLemma;

public abstract class ComputerFirstPane
extends PumpingLemmaInputPane {
    private static String OBJECTIVE = "Prevent the computer from finding a valid partition.";
    private static String DESCRIBE_M = "I have selected a value for m, displayed below.";
    private static String PROMPT_W = "Please enter a possible value for w and press \"Enter\".";
    private static String DESCRIBE_DECOMPOSITION = "I have decomposed w into the following...";
    private static String PROMPT_I = "Please enter a possible value for i and press \"Enter\".";
    protected JLabel decompLabel;

    public ComputerFirstPane(PumpingLemma pumpingLemma, String string) {
        super(pumpingLemma, string);
        pumpingLemma.setFirstPlayer("Computer");
    }

    @Override
    protected JPanel initDecompPanel() {
        JPanel jPanel = new JPanel();
        this.decompLabel = new JLabel();
        jPanel.add(this.decompLabel);
        jPanel.setBorder(BorderFactory.createTitledBorder("3. " + DESCRIBE_DECOMPOSITION));
        jPanel.setMaximumSize(new Dimension(ComputerFirstPane.MAX_SIZE.width, ComputerFirstPane.MAX_SIZE.height / 5));
        jPanel.setPreferredSize(new Dimension(ComputerFirstPane.MAX_SIZE.width, ComputerFirstPane.MAX_SIZE.height / 5));
        return jPanel;
    }

    @Override
    public void resetDecompPanel() {
        this.decompLabel.setText("");
    }

    @Override
    public void setDecomposition(int[] nArray) {
        this.myLemma.setDecomposition(nArray);
        this.decompLabel.setText(this.myLemma.getDecompositionAsString());
    }

    @Override
    protected String addTopGameFeatures(JButton jButton) {
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComputerFirstPane.this.myWDisplay.setText("");
                ComputerFirstPane.this.updateTopPane(false);
                ComputerFirstPane.this.reset();
                ComputerFirstPane.this.myLemma.chooseM();
                ComputerFirstPane.this.myMDisplay.setText(Integer.toString(ComputerFirstPane.this.myLemma.getM()));
            }
        });
        return OBJECTIVE;
    }

    @Override
    protected String addMGameFeatures() {
        this.myMDisplay = new JTextArea(1, 10);
        this.myMDisplay.setEditable(false);
        if (this.myLemma.getM() == -1) {
            this.myLemma.chooseM();
        }
        this.myMDisplay.setText(Integer.toString(this.myLemma.getM()));
        return DESCRIBE_M;
    }

    @Override
    protected String addWGameFeatures() {
        this.myWDisplay = new JTextField(20);
        ((JTextField)this.myWDisplay).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 3; i < ComputerFirstPane.this.stages.length; ++i) {
                    ComputerFirstPane.this.stages[i].setVisible(false);
                }
                String string = ComputerFirstPane.this.myWDisplay.getText();
                if (ComputerFirstPane.this.myLemma.isInLang(string) && string.length() >= ComputerFirstPane.this.myLemma.getM()) {
                    ComputerFirstPane.this.myLemma.setW(string);
                    ComputerFirstPane.this.stages[3].setVisible(true);
                    ComputerFirstPane.this.stages[4].setVisible(true);
                    ComputerFirstPane.this.myIDisplay.setText("");
                    ComputerFirstPane.this.myPumpedStringDisplay.setText("");
                    ComputerFirstPane.this.myLemma.chooseDecomposition();
                    ComputerFirstPane.this.decompLabel.setText("\n\n" + ComputerFirstPane.this.myLemma.getDecompositionAsString());
                    ComputerFirstPane.this.resetMessages();
                    ComputerFirstPane.this.leftPanel.revalidate();
                } else {
                    String string2 = string.length() >= ComputerFirstPane.this.myLemma.getM() ? "That string was not in the language.  Please enter another." : "Remember |w| must be >= m";
                    ComputerFirstPane.this.myWDisplay.selectAll();
                    ComputerFirstPane.this.stageMessages[2].setText(string2);
                }
            }
        });
        return PROMPT_W;
    }

    @Override
    protected String addIGameFeatures() {
        this.myIDisplay = new JTextField(20);
        ((JTextField)this.myIDisplay).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(ComputerFirstPane.this.myIDisplay.getText());
                    if (n < 0 || n == 1 || n > 12) {
                        throw new NumberFormatException();
                    }
                    ComputerFirstPane.this.stages[5].setVisible(true);
                    ComputerFirstPane.this.myLemma.setI(n);
                    if (ComputerFirstPane.this.myLemma.isInLang(ComputerFirstPane.this.myLemma.createPumpedString())) {
                        ComputerFirstPane.this.myLemma.addAttempt(ComputerFirstPane.this.myLemma.getDecompositionAsString() + "; I = " + ComputerFirstPane.this.myLemma.getI() + "; <i>Failed</i>");
                    } else {
                        ComputerFirstPane.this.myLemma.addAttempt(ComputerFirstPane.this.myLemma.getDecompositionAsString() + "; I = " + ComputerFirstPane.this.myLemma.getI() + "; <i>Won</i>");
                    }
                    ComputerFirstPane.this.resetMessages();
                    ComputerFirstPane.this.displayEnd();
                    ComputerFirstPane.this.updateTopPane(false);
                    ComputerFirstPane.this.leftPanel.revalidate();
                    ComputerFirstPane.this.setCanvas();
                    ComputerFirstPane.this.myCanvas.stop();
                    if (ComputerFirstPane.this.myCases != null) {
                        ComputerFirstPane.this.myCases.setI(n);
                        ComputerFirstPane.this.myCases.setAddReplaceButtonsEnabled(true);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "Please enter a positive integer in range [0, 2...12] for best results.";
                    ComputerFirstPane.this.myIDisplay.selectAll();
                    ComputerFirstPane.this.stageMessages[4].setText(string);
                }
            }
        });
        return PROMPT_I;
    }

    @Override
    public void displayEnd() {
        String string = this.myLemma.createPumpedString();
        this.myPumpedStringDisplay.setText(string);
        if (this.myLemma.isInLang(string)) {
            this.myLastWord.setText(this.createXYZ() + " = " + PumpingLemmaInputPane.toHTMLString(string) + " = " + string + " is in the language.  Please try again.");
        } else {
            this.myLastWord.setText(this.createXYZ() + " = " + PumpingLemmaInputPane.toHTMLString(string) + " = " + string + " is NOT in the language.  YOU WIN!");
        }
    }
}

