/*
 * Decompiled with CFR 0.152.
 */
package gui.minimize;

import automata.State;
import automata.Transition;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import automata.fsa.FiniteStateAutomaton;
import automata.fsa.Minimizer;
import gui.environment.FrameFactory;
import gui.viewer.SelectionDrawer;
import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;

class BuilderController {
    private FiniteStateAutomaton dfa;
    private FiniteStateAutomaton minDfa;
    private SelectionDrawer drawer;
    private Minimizer minimizer;
    private DefaultTreeModel tree;
    private Component view;
    Set remainingTransitions;

    public BuilderController(FiniteStateAutomaton finiteStateAutomaton, FiniteStateAutomaton finiteStateAutomaton2, SelectionDrawer selectionDrawer, Minimizer minimizer, DefaultTreeModel defaultTreeModel, Component component) {
        this.dfa = finiteStateAutomaton;
        this.minDfa = finiteStateAutomaton2;
        this.drawer = selectionDrawer;
        this.minimizer = minimizer;
        this.tree = defaultTreeModel;
        this.view = component;
        this.determineTransitions();
        this.initTransitionListener();
    }

    private void determineTransitions() {
        this.remainingTransitions = new HashSet();
        State[] stateArray = this.minDfa.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            this.remainingTransitions.addAll(this.minimizer.getTransitionsForState(stateArray[i], this.minDfa, this.dfa, this.tree));
        }
    }

    private void initTransitionListener() {
        this.minDfa.addTransitionListener(new AutomataTransitionListener(){

            @Override
            public void automataTransitionChange(AutomataTransitionEvent automataTransitionEvent) {
                if (!automataTransitionEvent.isAdd()) {
                    return;
                }
                Transition transition = automataTransitionEvent.getTransition();
                if (!BuilderController.this.remainingTransitions.contains(transition)) {
                    JOptionPane.showMessageDialog(BuilderController.this.view, "That transition is not correct!");
                    BuilderController.this.minDfa.removeTransition(transition);
                } else {
                    BuilderController.this.remainingTransitions.remove(transition);
                }
            }
        });
    }

    public void hint() {
        if (this.remainingTransitions.size() == 0) {
            JOptionPane.showMessageDialog(this.view, "All transitions are in place already!");
            return;
        }
        Iterator iterator = new HashSet(this.remainingTransitions).iterator();
        Transition transition = (Transition)iterator.next();
        this.minDfa.addTransition(transition);
    }

    public void complete() {
        if (this.remainingTransitions.size() == 0) {
            JOptionPane.showMessageDialog(this.view, "All transitions are in place already!");
            return;
        }
        for (Transition transition : new HashSet(this.remainingTransitions)) {
            this.minDfa.addTransition(transition);
        }
    }

    public void done() {
        int n = this.remainingTransitions.size();
        if (n != 0) {
            Transition transition = (Transition)this.remainingTransitions.iterator().next();
            this.drawer.addSelected(transition.getFromState());
            JOptionPane.showMessageDialog(this.view, n + " transition" + (n == 1 ? "" : "s") + " remain " + "to be placed.\n" + "One comes from the state highlighted.");
            this.drawer.clearSelected();
            return;
        }
        JOptionPane.showMessageDialog(this.view, "The minimized automaton is fully built!\nIt will now be placed in a new window.");
        FrameFactory.createFrame((FiniteStateAutomaton)this.minDfa.clone());
    }
}

