/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.parse.ParseNode;
import grammar.parse.UserParser;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.parse.BruteParsePane;
import gui.grammar.parse.SelectableUnrestrictedTreePanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;

public class UserControlParsePane
extends BruteParsePane {
    private UserParser myParser;
    private int mySelectedProductionIndex = -1;
    private Action myPreviousAction;
    private int myStepCount = 0;
    private int myPreviousCount = 0;
    private DefaultListModel myJListModel;
    private JList myStringJList;
    private String myTarget;

    public UserControlParsePane(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        super(grammarEnvironment, grammar, null);
        this.intializeGrammarTableSetting();
    }

    @Override
    protected void initView() {
        this.initTreePanel();
        JTable jTable = this.initParseTable();
        JScrollPane jScrollPane = jTable == null ? null : new JScrollPane(jTable);
        GrammarTable grammarTable = this.initGrammarTable(this.grammar);
        JScrollPane jScrollPane2 = new JScrollPane(grammarTable);
        this.myJListModel = new DefaultListModel();
        this.myStringJList = new JList(this.myJListModel);
        this.myStringJList.setLayoutOrientation(2);
        this.addMultipleSelectionToJList();
        this.myStringJList.setVisibleRowCount(1);
        JScrollPane jScrollPane3 = new JScrollPane(this.myStringJList);
        this.treeDerivationPane.add((Component)this.initTreePanel(), "0");
        this.derivationPane = new JScrollPane(this.initDerivationTable());
        this.treeDerivationPane.add((Component)this.derivationPane, "1");
        this.bottomSplit = SplitPaneFactory.createSplit(this.environment, true, 0.3, jScrollPane2, this.treeDerivationPane);
        this.topSplit = SplitPaneFactory.createSplit(this.environment, true, 0.4, jScrollPane, this.initInputPanel());
        this.bottomSplit = SplitPaneFactory.createSplit(this.environment, false, 0.52, this.bottomSplit, jScrollPane3);
        this.mainSplit = SplitPaneFactory.createSplit(this.environment, false, 0.3, this.topSplit, this.bottomSplit);
        this.add((Component)this.mainSplit, "Center");
        this.add((Component)this.statusDisplay, "South");
        this.add((Component)new TableTextSizeSlider(grammarTable), "North");
    }

    private void addMultipleSelectionToJList() {
        this.myStringJList.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int n, int n2) {
                if (this.isSelectedIndex(n)) {
                    super.removeSelectionInterval(n, n2);
                } else {
                    super.addSelectionInterval(n, n2);
                }
            }
        });
    }

    private void intializeGrammarTableSetting() {
        this.grammarTable.setSelectionMode(0);
        this.grammarTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                UserControlParsePane.this.mySelectedProductionIndex = UserControlParsePane.this.grammarTable.getSelectedRow();
                if (UserControlParsePane.this.mySelectedProductionIndex > -1 && UserControlParsePane.this.mySelectedProductionIndex < UserControlParsePane.this.grammarTable.getRowCount() - 1 && UserControlParsePane.this.myTarget != null) {
                    UserControlParsePane.this.stepAction.setEnabled(true);
                } else {
                    UserControlParsePane.this.stepAction.setEnabled(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.grammarTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                UserControlParsePane.this.mySelectedProductionIndex = UserControlParsePane.this.grammarTable.getSelectedRow();
                if (UserControlParsePane.this.mySelectedProductionIndex > -1 && UserControlParsePane.this.mySelectedProductionIndex < UserControlParsePane.this.grammarTable.getRowCount() - 1 && UserControlParsePane.this.myTarget != null) {
                    UserControlParsePane.this.stepAction.setEnabled(true);
                } else {
                    UserControlParsePane.this.stepAction.setEnabled(false);
                }
            }
        });
    }

    @Override
    public void input(String string) {
        this.myTarget = string;
        this.startParseInput(string, null);
    }

    protected void previous() {
        ParseNode parseNode = this.myParser.getPreviousAnswer();
        this.addAnswerToList(parseNode.getDerivation());
        this.treePanel.setAnswer(parseNode);
        this.treePanel.repaint();
        if (parseNode.getProductions().length > 0) {
            this.statusDisplay.setText("Derived current Strings using " + parseNode.getProductions()[0] + " production");
        } else {
            this.statusDisplay.setText("");
        }
        ++this.myPreviousCount;
        if (this.myStepCount == this.myPreviousCount) {
            this.myPreviousAction.setEnabled(false);
            this.myStepCount = 0;
            this.myPreviousCount = 0;
        }
        this.stepAction.setEnabled(true);
        this.progress.setText(null);
    }

    @Override
    protected JToolBar initInputToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.startAction);
        this.myPreviousAction = new AbstractAction("Previous"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserControlParsePane.this.previous();
            }
        };
        this.myPreviousAction.setEnabled(false);
        jToolBar.add(this.myPreviousAction);
        this.stepAction.setEnabled(false);
        jToolBar.add(this.stepAction);
        jToolBar.addSeparator();
        final JComboBox<String> jComboBox = new JComboBox<String>(this.getViewChoices());
        jComboBox.setSelectedIndex(0);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserControlParsePane.this.changeView((String)jComboBox.getSelectedItem());
            }
        };
        jComboBox.addActionListener(actionListener);
        jToolBar.add(jComboBox);
        return jToolBar;
    }

    @Override
    public boolean step() {
        int n = this.myParser.checkValidAndParse(this.grammarTable.getSelectedRow());
        String string = this.myParser.getLHSForProduction(this.grammarTable.getSelectedRow());
        int n2 = string.length();
        int n3 = -1;
        if (n > 0) {
            if (n > 1) {
                int n4;
                if (this.myStringJList.getSelectedIndex() < 0) {
                    JOptionPane.showMessageDialog(this, "Multiple Variable Detected, Please click the Variable you want to continue", "Select Variable", 0);
                    return false;
                }
                String string2 = "";
                int[] nArray = this.myStringJList.getSelectedIndices();
                int n5 = 0;
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    if (!this.myJListModel.getElementAt(nArray[n4]).equals(string)) continue;
                    ++n5;
                }
                if (n5 == nArray.length) {
                    this.myParser.subsitute(nArray);
                    this.paintTree();
                    if (this.myParser.isFinished()) {
                        this.progress.setText("String Accepted!");
                        this.stepAction.setEnabled(false);
                    }
                    this.myPreviousAction.setEnabled(true);
                    ++this.myStepCount;
                    return true;
                }
                if (nArray.length != n2) {
                    JOptionPane.showMessageDialog(this, "Multiple Variable Detected, Please click the Variable you want to continue", "Select Variable", 0);
                    return false;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    string2 = string2 + this.myJListModel.getElementAt(this.myStringJList.getSelectedIndex() + n4);
                }
                if (!string.equals(string2)) {
                    JOptionPane.showMessageDialog(this, "Multiple Variable Detected, Please click the Variable you want to continue", "Select Variable", 0);
                    return false;
                }
                n3 = this.myStringJList.getSelectedIndex();
            }
            this.myParser.parse(n3);
            this.paintTree();
            if (this.myParser.isFinished()) {
                this.progress.setText("String Accepted!");
                this.stepAction.setEnabled(false);
            }
            this.myPreviousAction.setEnabled(true);
            ++this.myStepCount;
            return true;
        }
        JOptionPane.showMessageDialog(this, "Previous Derivation does not support this Production", "Bad Input", 0);
        this.stepAction.setEnabled(false);
        return false;
    }

    private void paintTree() {
        this.addAnswerToList(this.myParser.getAnswer().getDerivation());
        ParseNode parseNode = this.myParser.getAnswer();
        this.treePanel.setAnswer(parseNode);
        this.treePanel.repaint();
        if (parseNode.getProductions().length > 0) {
            this.statusDisplay.setText("Derived current Strings using " + parseNode.getProductions()[0] + " production");
        } else {
            this.statusDisplay.setText("");
        }
        if (this.myParser.isStringTerminal(parseNode.getDerivation())) {
            this.progress.setText("No Additional Production is Possible");
            this.stepAction.setEnabled(false);
        }
    }

    private void addAnswerToList(String string) {
        this.myJListModel.removeAllElements();
        for (int i = 0; i < string.length(); ++i) {
            this.myJListModel.addElement(string.substring(i, i + 1));
        }
    }

    @Override
    protected JComponent initTreePanel() {
        this.treePanel = new SelectableUnrestrictedTreePanel(this);
        return this.treePanel;
    }

    public void startParseInput(String string, UserParser userParser) {
        if (string.equals("")) {
            return;
        }
        if (userParser == null) {
            try {
                this.myParser = UserParser.get(this.grammar, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this, illegalArgumentException.getMessage(), "Bad Input", 0);
                return;
            }
        } else {
            this.myParser = userParser;
        }
        this.progress.setText("");
        this.myPreviousAction.setEnabled(false);
        this.stepAction.setEnabled(false);
        this.grammarTable.clearSelection();
        this.myStepCount = 0;
        this.myPreviousCount = 0;
        this.myParser.start();
        this.paintTree();
    }
}

