/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.LLParseTable;
import gui.environment.Universe;
import gui.grammar.parse.LLParsePane;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

class LLParseController {
    String ENTRY;
    int ENTRYP;
    private Production[] productions;
    private int P;
    private String STRING;
    private int NODECOUNT;
    private Stack STACK;
    private TreeNode[] NODES;
    private String derivationString;
    private LLParsePane pane;
    private DefaultTreeModel tree;
    private TreeNode[] nodes;
    private int stepMode = 1;
    private static final int INITIALIZE = 1;
    private static final int NORMAL = 2;
    private static final int REPLACING = 3;
    private static final int ERROR = 4;
    private static final int SUCCESS = 5;

    public LLParseController(LLParsePane lLParsePane) {
        this.pane = lLParsePane;
        this.productions = lLParsePane.grammar.getProductions();
    }

    public void initialize(String string) {
        this.dehighlight();
        ArrayList arrayList = new ArrayList();
        this.tree = this.parseTree(string, this.pane.grammar, this.pane.table, arrayList);
        this.pane.treeDrawer.setModel(this.tree);
        this.pane.treeDrawer.hideAll();
        this.pane.treePanel.repaint();
        this.pane.stepAction.setEnabled(true);
        this.pane.derivationModel.setRowCount(0);
        this.NODES = arrayList.toArray(new TreeNode[0]);
        this.STRING = string + "$";
        this.STACK = new Stack();
        this.P = 0;
        this.NODECOUNT = 0;
        this.stepMode = 1;
        this.updateStatus();
        this.pane.statusDisplay.setText("Press step to begin.");
    }

    private void updateStatus() {
        this.pane.stackDisplay.setText(this.stackString());
        this.pane.inputDisplay.setText(this.STRING.substring(this.P));
    }

    private String stackString() {
        Object[] objectArray = this.STACK.toArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    private String derivationString() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public void step() {
        String string = this.STRING.substring(this.P, this.P + 1);
        switch (this.stepMode) {
            case 1: {
                this.STACK.push(this.NODES[0]);
                this.pane.treeDrawer.show(this.NODES[0]);
                this.pane.treePanel.repaint();
                ++this.NODECOUNT;
                this.stepMode = 2;
                this.updateStatus();
                this.pane.statusDisplay.setText("Initialization complete.");
                this.derivationString = this.pane.grammar.getStartVariable();
                this.pane.derivationModel.addRow(new String[]{"", this.derivationString});
                break;
            }
            case 2: {
                this.dehighlight();
                if (this.STACK.empty()) {
                    this.stepMode = 5;
                    this.step();
                    return;
                }
                String string2 = this.STACK.peek().toString();
                if (this.pane.grammar.isTerminal(string2)) {
                    if (string2.equals(string)) {
                        TreeNode treeNode = (TreeNode)this.STACK.pop();
                        this.pane.nodeDrawer.clearSelected();
                        this.pane.nodeDrawer.setSelected(treeNode, true);
                        this.pane.treePanel.repaint();
                        ++this.P;
                        this.pane.statusDisplay.setText("Matched " + string + ".");
                    } else {
                        this.stepMode = 4;
                        this.pane.statusDisplay.setText("Stack and input don't match.");
                    }
                    this.updateStatus();
                    return;
                }
                if (this.pane.grammar.isVariable(string2)) {
                    TreeNode treeNode = (TreeNode)this.STACK.pop();
                    this.pane.nodeDrawer.clearSelected();
                    this.pane.nodeDrawer.setSelected(treeNode, true);
                    this.pane.treePanel.repaint();
                    this.ENTRY = this.get(string2, string);
                    if (this.ENTRY == null) {
                        this.stepMode = 4;
                        this.pane.statusDisplay.setText("No rule for " + string2 + " with " + string + " as lookahead.");
                        this.updateStatus();
                        return;
                    }
                    this.highlight(string2, string);
                    String string3 = new Production(string2, this.ENTRY).toString();
                    int n = this.derivationString.indexOf(string2.charAt(0));
                    this.derivationString = this.derivationString.substring(0, n) + this.ENTRY + this.derivationString.substring(n + 1);
                    this.pane.derivationModel.addRow(new String[]{string3, this.derivationString});
                    if (this.ENTRY.length() == 0) {
                        this.ENTRY = Universe.curProfile.getEmptyString();
                    }
                    this.ENTRYP = this.ENTRY.length() - 1;
                    this.pane.statusDisplay.setText("Replacing " + string2 + " with " + this.ENTRY + ".");
                    this.stepMode = 3;
                }
                this.updateStatus();
                return;
            }
            case 3: {
                if (this.ENTRYP < 0) {
                    this.stepMode = 2;
                    this.step();
                    return;
                }
                TreeNode treeNode = this.NODES[this.NODECOUNT++];
                this.pane.treeDrawer.show(treeNode);
                this.pane.treePanel.repaint();
                if (!treeNode.toString().equals(Universe.curProfile.getEmptyString())) {
                    this.STACK.push(treeNode);
                }
                --this.ENTRYP;
                this.updateStatus();
                return;
            }
            case 4: {
                this.dehighlight();
                this.pane.statusDisplay.setText("String rejected.");
                this.pane.stepAction.setEnabled(false);
                return;
            }
            case 5: {
                this.dehighlight();
                if (!string.equals("$")) {
                    this.pane.statusDisplay.setText("The stack is empty, but the input is not.");
                    this.stepMode = 4;
                } else {
                    this.pane.stepAction.setEnabled(false);
                    this.pane.statusDisplay.setText("String successfully parsed!");
                }
                return;
            }
        }
    }

    private void highlight(String string, String string2) {
        int n = this.pane.table.getRow(string);
        int n2 = this.pane.table.getColumn(string2);
        this.pane.tablePanel.highlight(n, n2);
        this.pane.tablePanel.repaint();
        this.pane.grammarTable.repaint();
    }

    private void highlight(int n) {
        this.pane.grammarTable.highlight(n, 0);
        this.pane.grammarTable.highlight(n, 2);
        this.pane.tablePanel.repaint();
        this.pane.grammarTable.repaint();
    }

    private void dehighlight() {
        this.pane.tablePanel.dehighlight();
        this.pane.grammarTable.dehighlight();
        this.pane.tablePanel.repaint();
        this.pane.grammarTable.repaint();
    }

    private String get(String string, String string2) {
        try {
            return (String)this.pane.table.get(string, string2).first();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    private DefaultTreeModel parseTree(String string, Grammar grammar, LLParseTable lLParseTable, List list) {
        int n = 0;
        string = string + "$";
        Stack<DefaultMutableTreeNode> stack = new Stack<DefaultMutableTreeNode>();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(grammar.getStartVariable());
        stack.push(defaultMutableTreeNode);
        list.add(defaultMutableTreeNode);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        String string2 = string.substring(n, n + 1);
        ++n;
        while (!stack.empty()) {
            String string3 = stack.peek().toString();
            if (this.pane.grammar.isTerminal(string3)) {
                if (string3.equals(string2)) {
                    stack.pop();
                    string2 = string.substring(n, n + 1);
                    ++n;
                    continue;
                }
                return defaultTreeModel;
            }
            if (!this.pane.grammar.isVariable(string3)) continue;
            String string4 = this.get(string3, string2);
            if (string4 == null) {
                return defaultTreeModel;
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)stack.pop();
            if (string4.length() == 0) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(Universe.curProfile.getEmptyString());
                defaultMutableTreeNode2.insert(defaultMutableTreeNode3, 0);
                list.add(defaultMutableTreeNode3);
                continue;
            }
            for (int i = string4.length() - 1; i >= 0; --i) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(string4.substring(i, i + 1));
                defaultMutableTreeNode2.insert(defaultMutableTreeNode4, 0);
                stack.push(defaultMutableTreeNode4);
                list.add(defaultMutableTreeNode4);
            }
        }
        return defaultTreeModel;
    }
}

