/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.CYKParser;
import grammar.parse.CYKTracer;
import grammar.parse.ParseNode;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.parse.BruteParsePane;
import gui.grammar.parse.SelectableUnrestrictedTreePanel;
import gui.sim.multiple.InputTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;

public class CYKParsePane
extends BruteParsePane {
    private CYKParser myParser;
    private Action myStepAction;
    private String myTarget;
    private Grammar myCNFGrammar;
    private boolean myTraceAvailable;
    private ParseNode myCurrentAnswerNode;
    private Production[] myAnswers;
    private LinkedList myQueue;
    private int myIndex;

    public CYKParsePane(GrammarEnvironment grammarEnvironment, Grammar grammar, Grammar grammar2) {
        super(grammarEnvironment, grammar, null);
        this.myCNFGrammar = grammar2;
        this.myParser = new CYKParser(this.myCNFGrammar);
    }

    public CYKParsePane(GrammarEnvironment grammarEnvironment, Grammar grammar, Grammar grammar2, InputTableModel inputTableModel) {
        super(grammarEnvironment, grammar, inputTableModel);
        this.myCNFGrammar = grammar2;
        this.myParser = new CYKParser(this.myCNFGrammar);
        this.myModel = inputTableModel;
    }

    @Override
    protected void initView() {
        this.initTreePanel();
        JTable jTable = this.initParseTable();
        JScrollPane jScrollPane = jTable == null ? null : new JScrollPane(jTable);
        GrammarTable grammarTable = this.initGrammarTable(this.grammar);
        JScrollPane jScrollPane2 = new JScrollPane(grammarTable);
        this.treeDerivationPane.add((Component)this.initTreePanel(), "0");
        this.derivationPane = new JScrollPane(this.initDerivationTable());
        this.treeDerivationPane.add((Component)this.derivationPane, "1");
        this.bottomSplit = SplitPaneFactory.createSplit(this.environment, true, 0.3, jScrollPane2, this.treeDerivationPane);
        this.topSplit = SplitPaneFactory.createSplit(this.environment, true, 0.4, jScrollPane, this.initInputPanel());
        this.mainSplit = SplitPaneFactory.createSplit(this.environment, false, 0.3, this.topSplit, this.bottomSplit);
        this.add((Component)this.mainSplit, "Center");
        this.add((Component)this.statusDisplay, "South");
        this.add((Component)new TableTextSizeSlider(grammarTable), "North");
    }

    @Override
    protected JComponent initTreePanel() {
        this.treePanel = new SelectableUnrestrictedTreePanel(this);
        return this.treePanel;
    }

    @Override
    public void input(String string) {
        this.statusDisplay.setText("");
        this.myTarget = string;
        this.treePanel.setAnswer(null);
        this.treePanel.repaint();
        this.derivationModel.setRowCount(0);
        this.myStepAction.setEnabled(false);
        if (this.myParser.solve(string)) {
            this.progress.setText("String is Accepted!");
            this.myTraceAvailable = true;
            this.myStepAction.setEnabled(true);
            this.traceBack();
        } else {
            this.progress.setText("String is Rejected!");
        }
    }

    @Override
    public void parseMultiple() {
        String[][] stringArray = this.myModel.getInputs();
        this.row = -1;
        while (this.row < stringArray.length - 1) {
            ++this.row;
            if (this.myParser.solve(stringArray[this.row][0])) {
                this.myModel.setResult(this.row, "Accept", null, this.environment.myTransducerStrings, this.row);
                continue;
            }
            this.myModel.setResult(this.row, "Reject", null, this.environment.myTransducerStrings, this.row);
        }
    }

    public void traceBack() {
        if (!this.myTraceAvailable) {
            return;
        }
        CYKTracer cYKTracer = new CYKTracer(this.grammar, this.myParser.getTrace());
        cYKTracer.traceBack();
        this.myAnswers = cYKTracer.getAnswer();
        if (!this.myAnswers[0].getLHS().equals(this.grammar.getStartVariable())) {
            for (int i = 1; i < this.myAnswers.length; ++i) {
                if (!this.myAnswers[i].getLHS().equals(this.grammar.getStartVariable())) continue;
                Production production = this.myAnswers[0];
                this.myAnswers[0] = this.myAnswers[i];
                this.myAnswers[i] = production;
                break;
            }
        }
        this.myCurrentAnswerNode = new ParseNode(this.grammar.getStartVariable(), new Production[0], new int[0]);
        this.myQueue = new LinkedList();
        this.myQueue.add(this.myCurrentAnswerNode);
        this.myIndex = 0;
        this.stepForward();
    }

    private void stepForward() {
        this.treePanel.setAnswer(this.myCurrentAnswerNode);
        this.treePanel.repaint();
        if (this.myCurrentAnswerNode.getDerivation().equals(this.myTarget)) {
            this.myStepAction.setEnabled(false);
            return;
        }
        ParseNode parseNode = (ParseNode)this.myQueue.removeFirst();
        String string = parseNode.getDerivation();
        int n = string.indexOf(this.myAnswers[this.myIndex].getLHS());
        if (n == -1) {
            this.myStepAction.setEnabled(false);
            return;
        }
        string = string.substring(0, n) + this.myAnswers[this.myIndex].getRHS() + string.substring(n + 1);
        int[] nArray = new int[]{n};
        Production[] productionArray = new Production[]{this.myAnswers[this.myIndex]};
        ParseNode parseNode2 = new ParseNode(string, productionArray, nArray);
        parseNode2 = new ParseNode(parseNode2);
        parseNode.add(parseNode2);
        this.myQueue.add(parseNode2);
        this.myCurrentAnswerNode = parseNode2;
        ++this.myIndex;
    }

    @Override
    protected JToolBar initInputToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.startAction);
        this.myStepAction = new AbstractAction("Step"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CYKParsePane.this.stepForward();
            }
        };
        this.myStepAction.setEnabled(false);
        jToolBar.add(this.myStepAction);
        jToolBar.addSeparator();
        final JComboBox<String> jComboBox = new JComboBox<String>(this.getViewChoices());
        jComboBox.setSelectedIndex(0);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CYKParsePane.this.changeView((String)jComboBox.getSelectedItem());
            }
        };
        jComboBox.addActionListener(actionListener);
        jToolBar.add(jComboBox);
        return jToolBar;
    }
}

