/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.parse.BruteParser;
import grammar.parse.BruteParserEvent;
import grammar.parse.BruteParserListener;
import gui.environment.GrammarEnvironment;
import gui.grammar.parse.ParsePane;
import gui.grammar.parse.UnrestrictedTreePanel;
import gui.sim.multiple.InputTableModel;
import gui.tree.SelectNodeDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.Timer;

public class BruteParsePane
extends ParsePane {
    public int row = -1;
    protected UnrestrictedTreePanel treePanel = new UnrestrictedTreePanel(this);
    protected SelectNodeDrawer nodeDrawer = new SelectNodeDrawer();
    protected JLabel progress = new JLabel(" ");
    protected BruteParser parser = null;
    protected InputTableModel myModel = null;
    protected Action pauseResumeAction = new AbstractAction("Pause"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BruteParser bruteParser = BruteParsePane.this.parser;
            synchronized (bruteParser) {
                if (BruteParsePane.this.parser == null) {
                    return;
                }
                if (BruteParsePane.this.parser.isActive()) {
                    BruteParsePane.this.parser.pause();
                } else {
                    BruteParsePane.this.parser.start();
                }
            }
        }
    };

    public BruteParsePane(GrammarEnvironment grammarEnvironment, Grammar grammar) {
        super(grammarEnvironment, grammar);
    }

    public BruteParsePane(GrammarEnvironment grammarEnvironment, Grammar grammar, InputTableModel inputTableModel) {
        super(grammarEnvironment, grammar);
        this.initView();
        this.myModel = inputTableModel;
    }

    @Override
    protected JTable initParseTable() {
        return null;
    }

    @Override
    protected JPanel initInputPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)new JLabel("Input"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.inputField, gridBagConstraints);
        this.inputField.addActionListener(this.startAction);
        jPanel2.add((Component)this.progress, gridBagConstraints);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)this.initInputToolbar(), "North");
        return jPanel;
    }

    @Override
    protected JToolBar initInputToolbar() {
        JToolBar jToolBar = super.initInputToolbar();
        jToolBar.add((Component)new JButton(this.pauseResumeAction), 1);
        this.pauseResumeAction.setEnabled(false);
        return jToolBar;
    }

    public void parseMultiple() {
        String[][] stringArray = this.myModel.getInputs();
        int n = 1;
        if (this.environment.myObjects != null) {
            n = this.environment.myObjects.size();
        }
        int n2 = stringArray.length / n;
        Grammar grammar = this.grammar;
        if (this.environment.myObjects != null) {
            grammar = (Grammar)this.environment.myObjects.get(0);
        }
        if (this.row < stringArray.length - 1) {
            ++this.row;
            if (this.row % n2 == 0 && this.environment.myObjects != null) {
                this.grammar = grammar = (Grammar)this.environment.myObjects.get(this.row / n2);
            }
            try {
                this.parser = BruteParser.get(this.grammar, stringArray[this.row][0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this, illegalArgumentException.getMessage(), "Bad Input", 0);
                return;
            }
            this.parseInput(stringArray[this.row][0], this.parser);
        }
    }

    public void parseInput(String string, BruteParser bruteParser) {
        if (string.equals("")) {
            return;
        }
        if (bruteParser == null) {
            try {
                this.parser = BruteParser.get(this.grammar, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this, illegalArgumentException.getMessage(), "Bad Input", 0);
                return;
            }
        } else {
            this.parser = bruteParser;
        }
        final Timer timer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BruteParsePane.this.parser == null) {
                    return;
                }
                String string = "Nodes generated: " + BruteParsePane.this.parser.getTotalNodeCount() + "(" + BruteParsePane.this.parser.getConsiderationNodeCount() + ")";
                BruteParsePane.this.progress.setText("Parser running.  " + string);
            }
        });
        this.parser.addBruteParserListener(new BruteParserListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bruteParserStateChange(BruteParserEvent bruteParserEvent) {
                BruteParser bruteParser = bruteParserEvent.getParser();
                synchronized (bruteParser) {
                    Object object;
                    String string = bruteParserEvent.getParser().getTotalNodeCount() + " nodes generated.";
                    String string2 = null;
                    switch (bruteParserEvent.getType()) {
                        case 0: {
                            BruteParsePane.this.pauseResumeAction.setEnabled(true);
                            BruteParsePane.this.pauseResumeAction.putValue("Name", "Pause");
                            timer.start();
                            string2 = "Parser started.";
                            BruteParsePane.this.statusDisplay.setText(string2);
                            break;
                        }
                        case 3: {
                            BruteParsePane.this.pauseResumeAction.setEnabled(false);
                            timer.stop();
                            string2 = "String rejected.";
                            if (BruteParsePane.this.myModel == null) break;
                            object = BruteParsePane.this.myModel.getInputs();
                            int n = 1;
                            if (BruteParsePane.this.environment.myObjects != null) {
                                n = BruteParsePane.this.environment.myObjects.size();
                            }
                            int n2 = ((String[][])object).length / n;
                            BruteParsePane.this.myModel.setResult(BruteParsePane.this.row, "Reject", null, BruteParsePane.this.environment.myTransducerStrings, BruteParsePane.this.row % n2 * 2);
                            BruteParsePane.this.parseMultiple();
                            break;
                        }
                        case 1: {
                            timer.stop();
                            BruteParsePane.this.pauseResumeAction.putValue("Name", "Resume");
                            BruteParsePane.this.pauseResumeAction.setEnabled(true);
                            string2 = "Parser paused.";
                            BruteParsePane.this.statusDisplay.setText(string2);
                            break;
                        }
                        case 2: {
                            BruteParsePane.this.pauseResumeAction.setEnabled(false);
                            BruteParsePane.this.stepAction.setEnabled(true);
                            timer.stop();
                            string2 = "String accepted!";
                            if (BruteParsePane.this.myModel == null) break;
                            BruteParsePane.this.myModel.setResult(BruteParsePane.this.row, "Accept", null, BruteParsePane.this.environment.myTransducerStrings, BruteParsePane.this.row);
                            BruteParsePane.this.parseMultiple();
                        }
                    }
                    BruteParsePane.this.progress.setText(string2 + "  " + string);
                    if (BruteParsePane.this.parser.isFinished()) {
                        if (!bruteParserEvent.isAccept()) {
                            BruteParsePane.this.treePanel.setAnswer(null);
                            BruteParsePane.this.treePanel.repaint();
                            BruteParsePane.this.stepAction.setEnabled(false);
                            BruteParsePane.this.statusDisplay.setText("Try another string.");
                            return;
                        }
                        object = bruteParserEvent.getParser().getAnswer();
                        while ((object = object.getParent()) != null) {
                        }
                        BruteParsePane.this.statusDisplay.setText("Press step to show derivations.");
                        BruteParsePane.this.treePanel.setAnswer(bruteParserEvent.getParser().getAnswer());
                        BruteParsePane.this.treePanel.repaint();
                    }
                }
            }
        });
        this.parser.start();
    }

    @Override
    public void input(String string) {
        if (this.parser != null) {
            this.parser.pause();
        }
        this.parseInput(string, null);
    }

    @Override
    protected String[] getViewChoices() {
        return new String[]{"Noninverted Tree", "Derivation Table"};
    }

    @Override
    public boolean step() {
        boolean bl = false;
        if (this.treePanel.next()) {
            this.stepAction.setEnabled(false);
            bl = true;
        }
        this.treePanel.repaint();
        return bl;
    }

    @Override
    protected JComponent initTreePanel() {
        return this.treePanel;
    }
}

