/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.convert;

import automata.Automaton;
import grammar.Grammar;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBox;
import gui.editor.TransitionTool;
import gui.environment.Environment;
import gui.grammar.convert.ConvertController;
import gui.grammar.convert.GrammarViewer;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class ConvertPane
extends JPanel {
    private Grammar grammar;
    private GrammarViewer grammarViewer;
    private SelectionDrawer automatonDrawer;
    private Automaton automaton;
    private EditorPane editorPane;

    public ConvertPane(Grammar grammar, Automaton automaton, Map map, Environment environment) {
        this.grammar = grammar;
        this.automaton = automaton;
        this.setLayout(new BorderLayout());
        JSplitPane jSplitPane = SplitPaneFactory.createSplit(environment, true, 0.4, null, null);
        this.add((Component)jSplitPane, "Center");
        this.grammarViewer = new GrammarViewer(grammar);
        this.add((Component)new TableTextSizeSlider(this.grammarViewer), "North");
        JScrollPane jScrollPane = new JScrollPane(this.grammarViewer);
        jSplitPane.setLeftComponent(jScrollPane);
        this.automatonDrawer = new SelectionDrawer(automaton);
        EditorPane editorPane = new EditorPane(this.automatonDrawer, new ToolBox(){

            @Override
            public List tools(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
                LinkedList<Tool> linkedList = new LinkedList<Tool>();
                linkedList.add(new ArrowNontransitionTool(automatonPane, automatonDrawer));
                linkedList.add(new TransitionTool(automatonPane, automatonDrawer));
                return linkedList;
            }
        });
        ConvertController convertController = new ConvertController(this.grammarViewer, this.automatonDrawer, map, this);
        this.controlPanel(editorPane.getToolBar(), convertController);
        jSplitPane.setRightComponent(editorPane);
        this.editorPane = editorPane;
    }

    private void controlPanel(JToolBar jToolBar, final ConvertController convertController) {
        jToolBar.addSeparator();
        jToolBar.add(new AbstractAction("Show All"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                convertController.complete();
            }
        });
        jToolBar.add(new AbstractAction("Create Selected"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                convertController.createForSelected();
            }
        });
        jToolBar.add(new AbstractAction("Done?"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                convertController.isDone();
            }
        });
        jToolBar.add(new AbstractAction("Export"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                convertController.export();
            }
        });
    }

    public EditorPane getEditorPane() {
        return this.editorPane;
    }
}

