/*
 * Decompiled with CFR 0.152.
 */
package gui.environment;

import file.Encoder;
import gui.action.MultipleSimulateAction;
import gui.environment.FileChangeEvent;
import gui.environment.FileChangeListener;
import gui.environment.tag.CriticalTag;
import gui.environment.tag.EditorTag;
import gui.environment.tag.Satisfier;
import gui.environment.tag.Tag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class Environment
extends JPanel {
    public ArrayList myObjects;
    public ArrayList myTestStrings;
    public ArrayList myTransducerStrings;
    private Encoder encoder = null;
    private HashMap componentTags = new HashMap();
    public JTabbedPane tabbed;
    private transient HashSet changeListeners = new HashSet();
    private Serializable theMainObject;
    private File file;
    private Set fileListeners = new HashSet();
    private int criticalObjects = 0;
    private boolean dirty = false;

    public Environment(Serializable serializable) {
        this.theMainObject = serializable;
        this.clearDirty();
        this.initView();
    }

    public Serializable getObject() {
        return this.theMainObject;
    }

    public void addFileChangeListener(FileChangeListener fileChangeListener) {
        this.fileListeners.add(fileChangeListener);
    }

    public void removeFileChangeListener(FileChangeListener fileChangeListener) {
        this.fileListeners.remove(fileChangeListener);
    }

    protected void distributeFileChangeEvent(FileChangeEvent fileChangeEvent) {
        for (FileChangeListener fileChangeListener : this.fileListeners) {
            fileChangeListener.fileChanged(fileChangeEvent);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        File file2 = this.file;
        this.file = file;
        this.distributeFileChangeEvent(new FileChangeEvent(this, file2));
    }

    public void setMultipleObjects(ArrayList arrayList) {
        this.myObjects = arrayList;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    private void initView() {
        this.setLayout(new BorderLayout());
        this.tabbed = new JTabbedPane();
        super.add((Component)this.tabbed, "Center");
        this.tabbed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Environment.this.distributeChangeEvent();
            }
        });
    }

    public void add(Component component, String string, Tag tag) {
        this.componentTags.put(component, tag);
        this.tabbed.addTab(string, component);
        if (tag instanceof CriticalTag) {
            ++this.criticalObjects;
            if (this.criticalObjects == 1) {
                this.setEnabledEditorTagged(false);
            }
        }
        this.distributeChangeEvent();
    }

    public boolean contains(Component component) {
        return this.tabbed.indexOfComponent(component) != -1;
    }

    public void setEnabledEditorTagged(boolean bl) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            Component component = this.tabbed.getComponentAt(i);
            if (!((Tag)this.componentTags.get(component) instanceof EditorTag)) continue;
            this.tabbed.setEnabledAt(i, bl);
        }
    }

    public void add(Component component, String string) {
        this.add(component, string, new Tag(){});
    }

    public void setActive(Component component) {
        this.tabbed.setSelectedComponent(component);
    }

    public Component getActive() {
        return this.tabbed.getSelectedComponent();
    }

    public boolean isEnabled(Component component) {
        return this.tabbed.isEnabledAt(this.tabbed.indexOfComponent(component));
    }

    public void setEnabled(Component component, boolean bl) {
        this.tabbed.setEnabledAt(this.tabbed.indexOfComponent(component), bl);
        this.distributeChangeEvent();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected void distributeChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = new HashSet(this.changeListeners).iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    @Override
    public void remove(Component component) {
        this.tabbed.remove(component);
        Tag tag = (Tag)this.componentTags.remove(component);
        if (tag instanceof CriticalTag) {
            --this.criticalObjects;
            if (this.criticalObjects == 0) {
                this.setEnabledEditorTagged(true);
            }
        }
        this.distributeChangeEvent();
    }

    public Tag getTag(Component component) {
        return (Tag)this.componentTags.get(component);
    }

    @Override
    public Component[] getComponents() {
        Component[] componentArray = new Component[this.tabbed.getTabCount()];
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i] = this.tabbed.getComponentAt(i);
        }
        return componentArray;
    }

    public Component[] getComponents(Satisfier satisfier) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            Component component = this.tabbed.getComponentAt(i);
            if (!satisfier.satisfies(component, (Tag)this.componentTags.get(component))) continue;
            arrayList.add(component);
        }
        return arrayList.toArray(new Component[0]);
    }

    public boolean isPresent(Satisfier satisfier) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            Component component = this.tabbed.getComponentAt(i);
            if (!satisfier.satisfies(component, (Tag)this.componentTags.get(component))) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public void setNewMainObject(Serializable serializable) {
        this.theMainObject = serializable;
    }

    public void resizeSplit() {
        Component component;
        if (this.myObjects != null && this.tabbed != null && this.myObjects.size() > 0 && this.tabbed.getTabCount() == 1 && (component = this.getActive()) instanceof MultipleSimulateAction.MultiplePane) {
            MultipleSimulateAction.MultiplePane multiplePane = (MultipleSimulateAction.MultiplePane)component;
            multiplePane.mySplit.setDividerLocation(0.5);
        }
    }
}

