/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import automata.turing.TMTransition;
import automata.turing.TuringMachine;
import gui.editor.TableTransitionCreator;
import gui.viewer.AutomatonPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TMTransitionCreator
extends TableTransitionCreator {
    private boolean blockTransition = false;
    private TuringMachine machine;
    private static String[] DIRS = new String[]{"R", "S", "L"};
    private static JComboBox BOX = new JComboBox<String>(DIRS);
    private static KeyStroke[] STROKES;
    private static final Action CHANGE_ACTION;

    public TMTransitionCreator(AutomatonPane automatonPane) {
        super(automatonPane);
        this.machine = (TuringMachine)automatonPane.getDrawer().getAutomaton();
    }

    @Override
    protected Transition initTransition(State state, State state2) {
        if (!this.blockTransition) {
            return this.initTransition(state, state2, "R");
        }
        return this.initTransition(state, state2, "S");
    }

    protected Transition initTransition(State state, State state2, String string) {
        String[] stringArray = new String[this.machine.tapes()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        String[] stringArray2 = stringArray;
        if (this.blockTransition) {
            stringArray2 = new String[this.machine.tapes()];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = "~";
            }
        }
        String[] stringArray3 = new String[this.machine.tapes()];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = string;
        }
        TMTransition tMTransition = new TMTransition(state, state2, stringArray, stringArray2, stringArray3);
        tMTransition.setBlockTransition(this.blockTransition);
        return tMTransition;
    }

    private String[][] arraysForTransition(TMTransition tMTransition) {
        String[][] stringArray = new String[this.machine.tapes()][3];
        for (int i = this.machine.tapes() - 1; i >= 0; --i) {
            stringArray[i][0] = tMTransition.getRead(i);
            stringArray[i][1] = tMTransition.getWrite(i);
            if (stringArray[i][0].equals("\u25a1")) {
                stringArray[i][0] = "";
            }
            if (stringArray[i][1].equals("\u25a1")) {
                stringArray[i][1] = "";
            }
            stringArray[i][2] = tMTransition.getDirection(i);
        }
        return stringArray;
    }

    @Override
    protected TableModel createModel(Transition transition) {
        final TMTransition tMTransition = (TMTransition)transition;
        return new AbstractTableModel(){
            String[][] s;
            String[] name;
            {
                this.s = TMTransitionCreator.this.arraysForTransition(tMTransition);
                this.name = new String[]{"Read", "Write", "Direction"};
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return this.s[n][n2];
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                this.s[n][n2] = (String)object;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (!TMTransitionCreator.this.blockTransition) {
                    return true;
                }
                return n2 == 0;
            }

            @Override
            public int getRowCount() {
                return TMTransitionCreator.this.machine.tapes();
            }

            @Override
            public int getColumnCount() {
                if (!TMTransitionCreator.this.blockTransition) {
                    return 3;
                }
                return 1;
            }

            @Override
            public String getColumnName(int n) {
                return this.name[n];
            }
        };
    }

    @Override
    protected JTable createTable(Transition transition) {
        JTable jTable = super.createTable(transition);
        if (!this.blockTransition) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(2);
            tableColumn.setCellEditor(new DefaultCellEditor(BOX){

                @Override
                public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                    JComboBox jComboBox = (JComboBox)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                    InputMap inputMap = jComboBox.getInputMap();
                    ActionMap actionMap = jComboBox.getActionMap();
                    Object object2 = new Object();
                    actionMap.put(object2, CHANGE_ACTION);
                    for (int i = 0; i < STROKES.length; ++i) {
                        inputMap.put(STROKES[i], object2);
                    }
                    return jComboBox;
                }
            });
        }
        return jTable;
    }

    @Override
    public Transition modifyTransition(Transition transition, TableModel tableModel) {
        TMTransition tMTransition = (TMTransition)transition;
        try {
            String[] stringArray = new String[this.machine.tapes()];
            String[] stringArray2 = new String[this.machine.tapes()];
            String[] stringArray3 = new String[this.machine.tapes()];
            for (int i = 0; i < this.machine.tapes(); ++i) {
                stringArray[i] = (String)tableModel.getValueAt(i, 0);
                stringArray2[i] = (String)tableModel.getValueAt(i, 1);
                stringArray3[i] = (String)tableModel.getValueAt(i, 2);
            }
            TMTransition tMTransition2 = new TMTransition(tMTransition.getFromState(), tMTransition.getToState(), stringArray, stringArray2, stringArray3);
            if (transition instanceof TMTransition) {
                TMTransition tMTransition3 = (TMTransition)transition;
                tMTransition2.setBlockTransition(tMTransition3.isBlockTransition());
            }
            return tMTransition2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.reportException(illegalArgumentException);
            return null;
        }
    }

    public boolean isBlockTransition() {
        return this.blockTransition;
    }

    public void setBlockTransition(boolean bl) {
        this.blockTransition = bl;
    }

    public static void setDirs(boolean bl) {
        int n;
        DIRS = bl ? new String[]{"R", "S", "L"} : new String[]{"R", "L"};
        STROKES = new KeyStroke[DIRS.length];
        for (n = 0; n < STROKES.length; ++n) {
            TMTransitionCreator.STROKES[n] = KeyStroke.getKeyStroke("shift " + DIRS[n]);
        }
        BOX.removeAllItems();
        for (n = 0; n < DIRS.length; ++n) {
            BOX.addItem(DIRS[n]);
        }
    }

    static {
        CHANGE_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                jComboBox.setSelectedItem(actionEvent.getActionCommand().toUpperCase());
            }
        };
        STROKES = new KeyStroke[DIRS.length];
        for (int i = 0; i < STROKES.length; ++i) {
            TMTransitionCreator.STROKES[i] = KeyStroke.getKeyStroke("shift " + DIRS[i]);
        }
    }
}

