/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.turing.TMState;
import automata.turing.TuringMachine;
import gui.editor.Tool;
import gui.editor.TransitionCreator;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class BuildingBlockTool
extends Tool {
    protected State first;
    protected Point hover;
    TMState block = null;

    public BuildingBlockTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer, TransitionCreator transitionCreator) {
        super(automatonPane, automatonDrawer);
    }

    public BuildingBlockTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
        super(automatonPane, automatonDrawer);
    }

    @Override
    public String getToolTip() {
        return "Building Block Creator";
    }

    @Override
    protected Icon getIcon() {
        URL uRL = this.getClass().getResource("/ICON/blocks.gif");
        return new ImageIcon(uRL);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.block = ((TuringMachine)this.getAutomaton()).createBlock(mouseEvent.getPoint());
        this.getView().repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.first == null) {
            return;
        }
        this.hover = mouseEvent.getPoint();
        this.getView().repaint();
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('b');
    }
}

