/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import gui.action.RestrictedAction;
import gui.environment.Environment;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class PrintAction
extends RestrictedAction {
    private Environment environment;

    public PrintAction(Environment environment) {
        super("Print", null);
        this.environment = environment;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, MAIN_MENU_MASK));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)this.environment.getActive();
        PrintUtilities.printComponent(jComponent);
    }

    public static interface Bounds {
        public Rectangle2D printerBounds();
    }

    private static class PrintUtilities
    implements Printable {
        private JComponent componentToBePrinted;

        public static void printComponent(JComponent jComponent) {
            new PrintUtilities(jComponent).print();
        }

        public PrintUtilities(JComponent jComponent) {
            this.componentToBePrinted = jComponent;
        }

        public void print() {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            if (printerJob == null) {
                System.err.println("Error in Printing");
            } else {
                if (this.componentToBePrinted instanceof Bounds) {
                    Bounds bounds = (Bounds)((Object)this.componentToBePrinted);
                    Rectangle2D rectangle2D = bounds.printerBounds();
                    Paper paper = new Paper();
                    paper.setSize(2.0 * rectangle2D.getX() + rectangle2D.getWidth(), 2.0 * rectangle2D.getY() + rectangle2D.getHeight());
                    paper.setImageableArea(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                    PageFormat pageFormat = new PageFormat();
                    pageFormat.setPaper(paper);
                    printerJob.setPrintable(this, pageFormat);
                } else {
                    printerJob.setPrintable(this);
                }
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        System.err.println("Error printing: " + printerException);
                    }
                }
            }
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n > 0) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            Rectangle rectangle = graphics2D.getClipBounds();
            Rectangle rectangle2 = new Rectangle(this.componentToBePrinted.getSize());
            double d = ((RectangularShape)rectangle).getWidth() / ((RectangularShape)rectangle2).getWidth();
            double d2 = ((RectangularShape)rectangle).getWidth() / ((RectangularShape)rectangle2).getWidth();
            if (d < d2) {
                graphics2D.scale(d, d);
            } else {
                graphics2D.scale(d2, d2);
            }
            this.componentToBePrinted.print(graphics2D);
            return 0;
        }
    }
}

