/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.NondeterminismDetector;
import automata.NondeterminismDetectorFactory;
import automata.State;
import gui.action.AutomatonAction;
import gui.editor.ArrowDisplayOnlyTool;
import gui.environment.Environment;
import gui.environment.tag.CriticalTag;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NondeterminismAction
extends AutomatonAction {
    private Automaton automaton;
    private Environment environment;

    public NondeterminismAction(Automaton automaton, Environment environment) {
        super("Highlight Nondeterminism", null);
        this.automaton = automaton;
        this.environment = environment;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SelectionDrawer selectionDrawer = new SelectionDrawer(this.automaton);
        NondeterminismDetector nondeterminismDetector = NondeterminismDetectorFactory.getDetector(this.automaton);
        State[] stateArray = nondeterminismDetector.getNondeterministicStates(this.automaton);
        for (int i = 0; i < stateArray.length; ++i) {
            selectionDrawer.addSelected(stateArray[i]);
        }
        AutomatonPane automatonPane = new AutomatonPane(selectionDrawer);
        NondeterminismPane nondeterminismPane = new NondeterminismPane(automatonPane);
        this.environment.add((Component)nondeterminismPane, "Nondeterminism", new CriticalTag(){});
        this.environment.setActive(nondeterminismPane);
    }

    public static boolean isApplicable(Object object) {
        return object instanceof Automaton;
    }

    private class NondeterminismPane
    extends JPanel {
        public NondeterminismPane(AutomatonPane automatonPane) {
            super(new BorderLayout());
            automatonPane.addMouseListener(new ArrowDisplayOnlyTool(automatonPane, automatonPane.getDrawer()));
            this.add((Component)automatonPane, "Center");
            this.add((Component)new JLabel("Nondeterministic states are highlighted."), "North");
        }
    }
}

