/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.fsa.FiniteStateAutomaton;
import automata.mealy.MealyMachine;
import automata.mealy.MooreMachine;
import automata.pda.PushdownAutomaton;
import automata.turing.TuringMachine;
import grammar.cfg.ContextFreeGrammar;
import grammar.lsystem.LSystem;
import gui.action.AboutAction;
import gui.action.EmptyStringCharacterAction;
import gui.action.NewHelpAction;
import gui.action.OpenAction;
import gui.action.QuitAction;
import gui.action.RestrictedAction;
import gui.action.SetUndoAmountAction;
import gui.action.TestAction;
import gui.environment.FrameFactory;
import gui.environment.Universe;
import gui.menu.MenuBarCreator;
import gui.pumping.CFPumpingLemmaChooser;
import gui.pumping.RegPumpingLemmaChooser;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import regular.RegularExpression;

public class NewAction
extends RestrictedAction {
    private static NewDialog DIALOG = null;

    public NewAction() {
        super("New...", null);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, MAIN_MENU_MASK));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        NewAction.showNew();
    }

    public static void closeNew() {
        DIALOG.dispose();
        DIALOG = null;
    }

    public static void showNew() {
        if (DIALOG == null) {
            DIALOG = new NewDialog();
        }
        DIALOG.setVisible(true);
        DIALOG.toFront();
    }

    public static void hideNew() {
        DIALOG.setVisible(false);
    }

    private static void createWindow(Serializable serializable) {
        DIALOG.setVisible(false);
        FrameFactory.createFrame(serializable);
    }

    private static class NewDialog
    extends JFrame {
        public NewDialog() {
            super("JFLAP 7.0");
            this.getContentPane().setLayout(new GridLayout(0, 1));
            this.initMenu();
            this.initComponents();
            this.setResizable(false);
            this.pack();
            this.setLocation(50, 50);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    if (Universe.numberOfFrames() > 0) {
                        NewDialog.this.setVisible(false);
                    } else {
                        QuitAction.beginQuit();
                    }
                }
            });
        }

        private void initMenu() {
            Object object;
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            if (Universe.CHOOSER != null) {
                MenuBarCreator.addItem(jMenu, new OpenAction());
            }
            try {
                object = System.getSecurityManager();
                if (object != null) {
                    ((SecurityManager)object).checkExit(0);
                }
                MenuBarCreator.addItem(jMenu, new QuitAction());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            jMenuBar.add(jMenu);
            jMenu = new JMenu("Help");
            MenuBarCreator.addItem(jMenu, new NewHelpAction());
            MenuBarCreator.addItem(jMenu, new AboutAction());
            jMenuBar.add(jMenu);
            jMenu = new JMenu("Batch");
            MenuBarCreator.addItem(jMenu, new TestAction());
            jMenuBar.add(jMenu);
            jMenu = new JMenu("Preferences");
            object = new JMenu("Turing Machine Preferences");
            ((JMenu)object).add(Universe.curProfile.getTuringFinalCheckBox());
            ((JMenu)object).add(Universe.curProfile.getAcceptByFinalStateCheckBox());
            ((JMenu)object).add(Universe.curProfile.getAcceptByHaltingCheckBox());
            ((JMenu)object).add(Universe.curProfile.getAllowStayCheckBox());
            MenuBarCreator.addItem(jMenu, new EmptyStringCharacterAction());
            jMenu.add(new SetUndoAmountAction());
            jMenu.add((JMenuItem)object);
            jMenuBar.add(jMenu);
            this.setJMenuBar(jMenuBar);
        }

        private void initComponents() {
            JButton jButton = null;
            jButton = new JButton("Finite Automaton");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewAction.createWindow(new FiniteStateAutomaton());
                }
            });
            this.getContentPane().add(jButton);
            jButton = new JButton("Mealy Machine");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewAction.createWindow(new MealyMachine());
                }
            });
            this.getContentPane().add(jButton);
            jButton = new JButton("Moore Machine");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewAction.createWindow(new MooreMachine());
                }
            });
            this.getContentPane().add(jButton);
            jButton = new JButton("Pushdown Automaton");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = new Object[]{"Multiple Character Input", "Single Character Input"};
                    Object object = JOptionPane.showInputDialog(null, "Type of PDA Input", "Input", 1, null, objectArray, objectArray[0]);
                    if (object == objectArray[0]) {
                        NewAction.createWindow(new PushdownAutomaton());
                    } else if (object == objectArray[1]) {
                        NewAction.createWindow(new PushdownAutomaton(true));
                    }
                }
            });
            this.getContentPane().add(jButton);
            jButton = new JButton("Turing Machine");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewAction.createWindow(new TuringMachine(1));
                }
            });
            this.getContentPane().add(jButton);
            jButton = new JButton("Multi-Tape Turing Machine");
            jButton.addActionListener(new ActionListener(){
                private Integer[] INTS = null;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Number number;
                    if (this.INTS == null) {
                        this.INTS = new Integer[4];
                        for (int i = 0; i < this.INTS.length; ++i) {
                            this.INTS[i] = new Integer(i + 2);
                        }
                    }
                    if ((number = (Number)JOptionPane.showInputDialog(NewDialog.this.getContentPane(), "How many tapes?", "Multi-tape Machine", 3, null, this.INTS, this.INTS[0])) == null) {
                        return;
                    }
                    NewAction.createWindow(new TuringMachine(number.intValue()));
                }
            });
            this.getContentPane().add(jButton);
            jButton = new JButton("Grammar");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewAction.createWindow(new ContextFreeGrammar());
                }
            });
            this.getContentPane().add(jButton);
            jButton = new JButton("L-System");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewAction.createWindow(new LSystem());
                }
            });
            this.getContentPane().add(jButton);
            jButton = new JButton("Regular Expression");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewAction.createWindow(new RegularExpression());
                }
            });
            this.getContentPane().add(jButton);
            jButton = new JButton("Regular Pumping Lemma");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewAction.createWindow(new RegPumpingLemmaChooser());
                }
            });
            this.getContentPane().add(jButton);
            jButton = new JButton("Context-Free Pumping Lemma");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewAction.createWindow(new CFPumpingLemmaChooser());
                }
            });
            this.getContentPane().add(jButton);
        }
    }
}

