/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import grammar.lsystem.LSystem;
import gui.action.LSystemAction;
import gui.environment.LSystemEnvironment;
import gui.environment.tag.CriticalTag;
import gui.lsystem.DisplayPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class LSystemDisplay
extends LSystemAction {
    public LSystemDisplay(LSystemEnvironment lSystemEnvironment) {
        super(lSystemEnvironment, "Render System", null);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, MAIN_MENU_MASK));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        LSystem lSystem = this.getEnvironment().getLSystem();
        if (lSystem.getAxiom().size() == 0) {
            JOptionPane.showMessageDialog(this.getEnvironment(), "The axiom must have one or more symbols.", "Nonempty Axiom Required", 0);
            return;
        }
        try {
            DisplayPane displayPane = new DisplayPane(lSystem);
            this.getEnvironment().add((Component)displayPane, "L-S Render", new CriticalTag(){});
            this.getEnvironment().setActive(displayPane);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            JOptionPane.showMessageDialog(this.getEnvironment(), "Sorry, but this uses features requiring Java 1.4 or later!", "JVM too primitive", 0);
            return;
        }
    }
}

