/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import gui.TooltipAction;
import gui.action.AutomatonAction;
import gui.environment.AutomatonEnvironment;
import gui.environment.tag.CriticalTag;
import gui.grammar.automata.ConvertController;
import gui.grammar.automata.ConvertPane;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;

public abstract class ConvertAutomatonToGrammarAction
extends AutomatonAction {
    private AutomatonEnvironment environment;
    private Automaton automaton;
    private ConvertController controller;

    public ConvertAutomatonToGrammarAction(AutomatonEnvironment automatonEnvironment) {
        super("Convert to Grammar", null);
        this.environment = automatonEnvironment;
        this.automaton = automatonEnvironment.getAutomaton();
    }

    public ConvertAutomatonToGrammarAction(String string, AutomatonEnvironment automatonEnvironment) {
        super(string, null);
        this.environment = automatonEnvironment;
        this.automaton = automatonEnvironment.getAutomaton();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.automaton.getInitialState() == null) {
            JOptionPane.showMessageDialog(this.environment, "There must be an initial state!", "No Initial State", 0);
            return;
        }
        if (!this.checkAutomaton()) {
            return;
        }
        Automaton automaton = (Automaton)this.getAutomaton().clone();
        final ConvertPane convertPane = new ConvertPane(this.environment, automaton);
        final ConvertController convertController = this.initializeController(convertPane, convertPane.getDrawer(), automaton);
        AutomatonPane automatonPane = convertPane.getAutomatonPane();
        automatonPane.addMouseListener(new MouseAdapter(){
            private SelectionDrawer drawer;
            {
                this.drawer = convertPane.getDrawer();
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Serializable serializable = this.drawer.stateAtPoint(mouseEvent.getPoint());
                if (serializable == null) {
                    serializable = this.drawer.transitionAtPoint(mouseEvent.getPoint());
                }
                if (serializable == null) {
                    return;
                }
                convertController.revealObjectProductions(serializable);
            }
        });
        JToolBar jToolBar = this.initToolbar(convertController);
        convertPane.add((Component)jToolBar, "North");
        this.environment.add((Component)convertPane, "Convert to Grammar", new CriticalTag(){});
        this.environment.setActive(convertPane);
    }

    private JToolBar initToolbar(final ConvertController convertController) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new TooltipAction("Hint", "Shows the productions for one object."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                convertController.revealRandomProductions();
            }
        });
        jToolBar.add(new TooltipAction("Show All", "Shows all productions remaining."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                convertController.revealAllProductions();
            }
        });
        jToolBar.addSeparator();
        jToolBar.add(new TooltipAction("What's Left?", "Highlights remaining objects to convert."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                convertController.highlightUntransformed();
            }
        });
        jToolBar.add(new TooltipAction("Export", "Exports a finished grammar to a new window."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                convertController.exportGrammar();
            }
        });
        return jToolBar;
    }

    protected abstract boolean checkAutomaton();

    protected abstract ConvertController initializeController(ConvertPane var1, SelectionDrawer var2, Automaton var3);

    protected Automaton getAutomaton() {
        return this.automaton;
    }

    protected AutomatonEnvironment getEnvironment() {
        return this.environment;
    }
}

