/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class GrowableTableModel
extends AbstractTableModel
implements Cloneable {
    protected int columns;
    protected List data = new ArrayList();

    public GrowableTableModel(int n) {
        this.columns = n;
        this.clear();
    }

    public GrowableTableModel(GrowableTableModel growableTableModel) {
        this.copy(growableTableModel);
    }

    public void clear() {
        this.data.clear();
        this.data.add(this.initializeRow(0));
        this.fireTableDataChanged();
    }

    public void copy(GrowableTableModel growableTableModel) {
        this.columns = growableTableModel.getColumnCount();
        this.data.clear();
        for (Object[] objectArray : growableTableModel.data) {
            Object[] objectArray2 = new Object[this.columns];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i];
            }
            this.data.add(objectArray2);
        }
        this.fireTableDataChanged();
    }

    protected Object[] initializeRow(int n) {
        Object[] objectArray = new Object[this.getColumnCount()];
        Arrays.fill(objectArray, null);
        return objectArray;
    }

    @Override
    public final int getColumnCount() {
        return this.columns;
    }

    @Override
    public final int getRowCount() {
        return this.data.size();
    }

    public boolean deleteRow(int n) {
        if (n < 0 || n > this.data.size() - 2) {
            return false;
        }
        this.data.remove(n);
        this.fireTableRowsDeleted(n, n);
        return true;
    }

    public void insertRow(Object[] objectArray, int n) {
        if (objectArray.length != this.columns) {
            throw new IllegalArgumentException("Data length is " + objectArray.length + ", should be " + this.columns + ".");
        }
        this.data.add(n, objectArray);
        this.fireTableRowsInserted(n, n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return ((Object[])this.data.get(n))[n2];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ((Object[])this.data.get((int)n))[n2] = object;
        if (n + 1 == this.getRowCount()) {
            this.data.add(this.initializeRow(n + 1));
            this.fireTableRowsInserted(n + 1, n + 1);
        }
        if (n >= this.getRowCount()) {
            this.data.add(this.initializeRow(n));
            this.fireTableRowsInserted(n, n);
        }
        this.fireTableCellUpdated(n, n2);
    }
}

