/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import automata.fsa.FiniteStateAutomaton;
import grammar.Grammar;
import grammar.Production;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class LRParseTable
extends AbstractTableModel
implements Serializable,
Cloneable {
    private String[] variables;
    private String[] terminals;
    private String[][] entries;
    private Grammar grammar;
    private Map symbolsToColumn = new HashMap();

    public LRParseTable(Grammar grammar, FiniteStateAutomaton finiteStateAutomaton) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(grammar.getTerminals()));
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(grammar.getVariables()));
        this.grammar = grammar;
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        arrayList.add("$");
        this.terminals = arrayList.toArray(new String[0]);
        this.variables = arrayList2.toArray(new String[0]);
        for (n = 0; n < this.terminals.length; ++n) {
            this.symbolsToColumn.put(this.terminals[n], new Integer(n + 1));
        }
        for (n = 0; n < this.variables.length; ++n) {
            this.symbolsToColumn.put(this.variables[n], new Integer(n + 1 + this.terminals.length));
        }
        this.entries = new String[finiteStateAutomaton.getStates().length][this.terminals.length + this.variables.length + 1];
        for (n = 0; n < this.entries.length; ++n) {
            for (int i = 0; i < this.entries[n].length; ++i) {
                this.entries[n][i] = i == 0 ? Integer.toString(n) : "";
            }
        }
    }

    public LRParseTable(LRParseTable lRParseTable) {
        this.terminals = lRParseTable.terminals;
        this.variables = lRParseTable.variables;
        this.grammar = lRParseTable.grammar;
        this.entries = new String[lRParseTable.entries.length][lRParseTable.entries[0].length];
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[i].length; ++j) {
                this.entries[i][j] = lRParseTable.entries[i][j];
            }
        }
        this.symbolsToColumn = lRParseTable.symbolsToColumn;
    }

    public Object clone() {
        return new LRParseTable(this);
    }

    public void setValueAt(String string, int n, String string2) {
        this.setValueAt((Object)string, n, this.columnForSymbol(string2));
    }

    public String getValueAt(int n, String string) {
        return (String)this.getValueAt(n, this.columnForSymbol(string));
    }

    public SortedSet getSetAt(int n, String string) {
        return this.getSetAt(n, this.columnForSymbol(string));
    }

    public void appendValueAt(String string, int n, String string2) {
        this.appendValueAt(string, n, this.columnForSymbol(string2));
    }

    public int columnForSymbol(String string) {
        Integer n = (Integer)this.symbolsToColumn.get(string);
        if (n == null) {
            throw new IllegalArgumentException(string + " is not in the grammar!");
        }
        return n;
    }

    @Override
    public int getRowCount() {
        return this.entries.length;
    }

    @Override
    public int getColumnCount() {
        return this.entries[0].length;
    }

    private String parseValue(String string, int n) {
        if (n < 1) {
            return null;
        }
        if (string.equals("")) {
            return "";
        }
        if (n > this.terminals.length) {
            try {
                int n2 = Integer.parseInt(string);
                return Integer.toString(n2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        string = string.toLowerCase();
        switch (string.charAt(0)) {
            case 'a': {
                return "acc";
            }
            case 'r': 
            case 's': {
                if (string.length() < 2) {
                    return null;
                }
                int n3 = 1;
                while (!Character.isDigit(string.charAt(n3))) {
                    ++n3;
                }
                try {
                    int n4 = Integer.parseInt(string.substring(n3));
                    return "" + string.charAt(0) + Integer.toString(n4);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
        }
        return null;
    }

    private String[] parseValues(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        TreeSet<String> treeSet = new TreeSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((string2 = this.parseValue(string2, n)) == null) continue;
            treeSet.add(string2);
        }
        return treeSet.toArray(new String[0]);
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return " ";
        }
        if (n > this.terminals.length) {
            return this.variables[n - 1 - this.terminals.length];
        }
        return this.terminals[n - 1];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        String[] stringArray = this.parseValues((String)object, n2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i]);
        }
        this.entries[n][n2] = stringBuffer.toString();
        this.fireTableCellUpdated(n, n2);
    }

    public void appendValueAt(String string, int n, int n2) {
        this.setValueAt((Object)(this.getValueAt(n, n2) + " " + string), n, n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.entries[n][n2];
    }

    public SortedSet getSetAt(int n, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.entries[n][n2]);
        TreeSet<String> treeSet = new TreeSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            treeSet.add(stringTokenizer.nextToken());
        }
        return treeSet;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    private String getContentDescription(String string) {
        switch (string.charAt(0)) {
            case 'a': {
                return "Accept";
            }
            case 's': {
                return "Shift current input and state " + string.substring(1) + " to stack";
            }
            case 'r': {
                Production[] productionArray = this.grammar.getProductions();
                int n = Integer.parseInt(string.substring(1));
                String string2 = "Reduce by production " + n + ", ";
                try {
                    string2 = string2 + productionArray[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    string2 = string2 + "which does not exist";
                }
                return string2;
            }
        }
        return "Goto state " + string;
    }

    public String getContentDescription(int n, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.entries[n][n2]);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (n3++ != 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(this.getContentDescription(string));
        }
        if (stringBuffer.length() == 0) {
            return "Reject";
        }
        return stringBuffer.toString();
    }
}

