/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import automata.State;
import automata.Transition;
import automata.UnreachableStatesDetector;
import automata.vdg.VDGTransition;
import automata.vdg.VariableDependencyGraph;
import grammar.Grammar;
import grammar.GrammarChecker;
import grammar.Production;
import grammar.ProductionChecker;
import grammar.cfg.ContextFreeGrammar;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class UselessProductionRemover {
    protected static String START_SYMBOL = "S";

    public static Set getCompleteUsefulVariableSet(Grammar grammar) {
        Set set = UselessProductionRemover.getNewUsefulVariableSet();
        while (UselessProductionRemover.areMoreVariablesThatBelongInUsefulVariableSet(grammar, set)) {
            String string = UselessProductionRemover.getVariableThatBelongsInUsefulVariableSet(grammar, set);
            UselessProductionRemover.addToUsefulVariableSet(string, set);
        }
        return set;
    }

    private static Set getNewUsefulVariableSet() {
        return new HashSet();
    }

    public static void addToUsefulVariableSet(String string, Set set) {
        set.add(string);
    }

    public static Set getTerminalProductions(Grammar grammar) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            String string = productionArray[i].getLHS();
            if (treeSet.contains(string)) continue;
            String string2 = productionArray[i].getRHS();
            for (int j = 0; j < string2.length(); ++j) {
                char c = string2.charAt(j);
                if (!ProductionChecker.isVariable(c)) continue;
                string = null;
                break;
            }
            if (string == null) continue;
            treeSet.add(string);
        }
        return treeSet;
    }

    public static Grammar getTerminalGrammar(Grammar grammar) {
        ContextFreeGrammar contextFreeGrammar = new ContextFreeGrammar();
        Set set = UselessProductionRemover.getCompleteUsefulVariableSet(grammar);
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(productionArray[i].getVariables()));
            hashSet.removeAll(set);
            if (hashSet.size() > 0) continue;
            contextFreeGrammar.addProduction(productionArray[i]);
        }
        contextFreeGrammar.setStartVariable(grammar.getStartVariable());
        return contextFreeGrammar;
    }

    public static String getVariableThatBelongsInUsefulVariableSet(Grammar grammar, Set set) {
        String[] stringArray = grammar.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!UselessProductionRemover.belongsInUsefulVariableSet(stringArray[i], grammar, set) || set.contains(stringArray[i])) continue;
            return stringArray[i];
        }
        return null;
    }

    private static boolean isInUsefulVariableSet(char c, Set set) {
        for (String string : set) {
            char c2 = string.charAt(0);
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    private static boolean isUsefulProduction(Production production, Set set) {
        ProductionChecker productionChecker = new ProductionChecker();
        String string = production.getRHS();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (ProductionChecker.isTerminal(c) || UselessProductionRemover.isInUsefulVariableSet(c, set)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidProduction(Production production, Set set) {
        String string = production.getLHS();
        for (int i = 0; i < string.length(); ++i) {
            if (UselessProductionRemover.isInUsefulVariableSet(string.charAt(i), set)) continue;
            return false;
        }
        return UselessProductionRemover.isUsefulProduction(production, set);
    }

    public static boolean belongsInUsefulVariableSet(String string, Grammar grammar, Set set) {
        GrammarChecker grammarChecker = new GrammarChecker();
        Production[] productionArray = GrammarChecker.getProductionsOnVariable(string, grammar);
        for (int i = 0; i < productionArray.length; ++i) {
            if (!UselessProductionRemover.isUsefulProduction(productionArray[i], set)) continue;
            return true;
        }
        return false;
    }

    public static boolean areMoreVariablesThatBelongInUsefulVariableSet(Grammar grammar, Set set) {
        return UselessProductionRemover.getVariableThatBelongsInUsefulVariableSet(grammar, set) != null;
    }

    public static Set getCompleteProductionWithUsefulVariableSet(Grammar grammar, Set set) {
        Set set2 = UselessProductionRemover.getNewProductionWithUsefulVariableSet();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (!UselessProductionRemover.belongsInProductionWithUsefulVariableSet(productionArray[i], set)) continue;
            set2.add(productionArray[i]);
        }
        return set2;
    }

    public static Set getNewProductionWithUsefulVariableSet() {
        return new HashSet();
    }

    public static boolean belongsInProductionWithUsefulVariableSet(Production production, Set set) {
        return UselessProductionRemover.isValidProduction(production, set);
    }

    public static void addToProductionWithUsefulVariableSet(Production production, Set set) {
        set.add(production);
    }

    public static void initializeVariableDependencyGraph(VariableDependencyGraph variableDependencyGraph, Grammar grammar) {
        String[] stringArray = UselessProductionRemover.getCompleteUsefulVariableSet(grammar).toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            double d = Math.PI * 2 * (double)i / (double)stringArray.length;
            Point point = new Point(200 + (int)(180.0 * Math.cos(d)), 200 + (int)(180.0 * Math.sin(d)));
            State state = variableDependencyGraph.createState(point);
            state.setName(stringArray[i]);
            if (!stringArray[i].equals(grammar.getStartVariable())) continue;
            variableDependencyGraph.setInitialState(state);
        }
    }

    public static boolean isDependentOn(String string, String string2, Grammar grammar) {
        GrammarChecker grammarChecker = new GrammarChecker();
        ProductionChecker productionChecker = new ProductionChecker();
        Production[] productionArray = GrammarChecker.getProductionsOnVariable(string, grammar);
        for (int i = 0; i < productionArray.length; ++i) {
            if (!ProductionChecker.isVariableInProduction(string2, productionArray[i])) continue;
            return true;
        }
        return false;
    }

    public static Transition getTransition(String string, String string2, VariableDependencyGraph variableDependencyGraph) {
        State state = UselessProductionRemover.getStateForVariable(string, variableDependencyGraph);
        State state2 = UselessProductionRemover.getStateForVariable(string2, variableDependencyGraph);
        return new VDGTransition(state, state2);
    }

    public static State getStateForVariable(String string, VariableDependencyGraph variableDependencyGraph) {
        State[] stateArray = variableDependencyGraph.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            State state = stateArray[i];
            if (!state.getName().equals(string)) continue;
            return state;
        }
        return null;
    }

    public static VariableDependencyGraph getVariableDependencyGraph(Grammar grammar) {
        VariableDependencyGraph variableDependencyGraph = new VariableDependencyGraph();
        UselessProductionRemover.initializeVariableDependencyGraph(variableDependencyGraph, grammar);
        String[] stringArray = UselessProductionRemover.getCompleteUsefulVariableSet(grammar).toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            for (int j = 0; j < stringArray.length; ++j) {
                String string2 = stringArray[j];
                if (j == i || !UselessProductionRemover.isDependentOn(string, string2, grammar)) continue;
                Transition transition = UselessProductionRemover.getTransition(string, string2, variableDependencyGraph);
                variableDependencyGraph.addTransition(transition);
            }
        }
        return variableDependencyGraph;
    }

    public static Transition[] getTransitionsForProduction(Production production, VariableDependencyGraph variableDependencyGraph) {
        ArrayList<Transition> arrayList = new ArrayList<Transition>();
        String string = production.getLHS();
        ProductionChecker productionChecker = new ProductionChecker();
        String string2 = production.getRHS();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (!ProductionChecker.isVariable(c)) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c);
            arrayList.add(UselessProductionRemover.getTransition(string, stringBuffer.toString(), variableDependencyGraph));
        }
        return arrayList.toArray(new Transition[0]);
    }

    public static String[] getUselessVariables(Grammar grammar, VariableDependencyGraph variableDependencyGraph) {
        ArrayList<String> arrayList = new ArrayList<String>();
        UnreachableStatesDetector unreachableStatesDetector = new UnreachableStatesDetector(variableDependencyGraph);
        State[] stateArray = unreachableStatesDetector.getUnreachableStates();
        for (int i = 0; i < stateArray.length; ++i) {
            arrayList.add(stateArray[i].getName());
        }
        return arrayList.toArray(new String[0]);
    }

    public static void removeProductionsForVariable(String string, Grammar grammar) {
        GrammarChecker grammarChecker = new GrammarChecker();
        Production[] productionArray = GrammarChecker.getProductionsWithVariable(string, grammar);
        for (int i = 0; i < productionArray.length; ++i) {
            grammar.removeProduction(productionArray[i]);
        }
    }

    private static Grammar getGrammarWithNoVariablesThatCantDeriveStrings(Set set) {
        ContextFreeGrammar contextFreeGrammar = new ContextFreeGrammar();
        for (Production production : set) {
            contextFreeGrammar.addProduction(production);
        }
        return contextFreeGrammar;
    }

    public static Grammar getUselessProductionlessGrammar(Grammar grammar) {
        ContextFreeGrammar contextFreeGrammar = new ContextFreeGrammar();
        contextFreeGrammar.setStartVariable(grammar.getStartVariable());
        if (!UselessProductionRemover.getCompleteUsefulVariableSet(grammar).contains(grammar.getStartVariable())) {
            return contextFreeGrammar;
        }
        grammar = UselessProductionRemover.getTerminalGrammar(grammar);
        VariableDependencyGraph variableDependencyGraph = UselessProductionRemover.getVariableDependencyGraph(grammar);
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(UselessProductionRemover.getUselessVariables(contextFreeGrammar, variableDependencyGraph)));
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            HashSet<String> hashSet2 = new HashSet<String>(Arrays.asList(productionArray[i].getVariables()));
            hashSet2.retainAll(hashSet);
            if (hashSet2.size() > 0) continue;
            contextFreeGrammar.addProduction(productionArray[i]);
        }
        return contextFreeGrammar;
    }
}

