/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.Grammar;
import grammar.GrammarChecker;
import grammar.Production;
import grammar.ProductionChecker;
import grammar.cfg.ContextFreeGrammar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class LambdaProductionRemover {
    protected String ZERO = "0";
    protected char ONE_CHAR = (char)49;

    public HashSet getNewLambdaSet() {
        return new HashSet();
    }

    public void addVariableToLambdaSet(String string, Set set) {
        if (!set.contains(string)) {
            set.add(string);
        }
    }

    public boolean isVariableWithLambdaProduction(String string, Grammar grammar) {
        ProductionChecker productionChecker = new ProductionChecker();
        GrammarChecker grammarChecker = new GrammarChecker();
        Production[] productionArray = GrammarChecker.getProductionsOnVariable(string, grammar);
        for (int i = 0; i < productionArray.length; ++i) {
            if (!ProductionChecker.isLambdaProduction(productionArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean areMoreVariablesWithLambdaProductions(Grammar grammar, Set set) {
        return this.getNewVariableWithLambdaProduction(grammar, set) != null;
    }

    public String getNewVariableWithLambdaProduction(Grammar grammar, Set set) {
        String[] stringArray = grammar.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            if (set.contains(stringArray[i]) || !this.isVariableWithLambdaProduction(stringArray[i], grammar)) continue;
            return stringArray[i];
        }
        return null;
    }

    public void addVariablesWithLambdaProductions(Grammar grammar, Set set) {
        while (this.areMoreVariablesWithLambdaProductions(grammar, set)) {
            String string = this.getNewVariableWithLambdaProduction(grammar, set);
            this.addVariableToLambdaSet(string, set);
        }
    }

    public boolean isInLambdaSet(String string, Set set) {
        return set.contains(string);
    }

    public boolean isReducableToLambdaProduction(Production production, Set set) {
        ProductionChecker productionChecker = new ProductionChecker();
        if (ProductionChecker.areTerminalsOnRHS(production)) {
            return false;
        }
        String[] stringArray = production.getVariablesOnRHS();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isInLambdaSet(stringArray[i], set)) continue;
            return false;
        }
        return true;
    }

    public boolean belongsInLambdaSet(String string, Grammar grammar, Set set) {
        if (this.isVariableWithLambdaProduction(string, grammar)) {
            return true;
        }
        GrammarChecker grammarChecker = new GrammarChecker();
        Production[] productionArray = GrammarChecker.getProductionsOnVariable(string, grammar);
        for (int i = 0; i < productionArray.length; ++i) {
            if (!this.isReducableToLambdaProduction(productionArray[i], set)) continue;
            return true;
        }
        return false;
    }

    public boolean areMoreVariablesToAddToLambdaSet(Grammar grammar, Set set) {
        return this.getNewVariableThatBelongsInLambdaSet(grammar, set) != null;
    }

    public String getNewVariableThatBelongsInLambdaSet(Grammar grammar, Set set) {
        String[] stringArray = grammar.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isInLambdaSet(stringArray[i], set) || !this.belongsInLambdaSet(stringArray[i], grammar, set)) continue;
            return stringArray[i];
        }
        return null;
    }

    public HashSet getCompleteLambdaSet(Grammar grammar) {
        HashSet hashSet = this.getNewLambdaSet();
        while (this.areMoreVariablesToAddToLambdaSet(grammar, hashSet)) {
            String string = this.getNewVariableThatBelongsInLambdaSet(grammar, hashSet);
            this.addVariableToLambdaSet(string, hashSet);
        }
        return hashSet;
    }

    public Production[] getProductionsToAddForProduction(Production production, Set set) {
        int n;
        String string;
        Object[] objectArray = new String[]{""};
        String string2 = production.getRHS();
        for (int i = 0; i < string2.length(); ++i) {
            string = string2.substring(i, i + 1);
            if (set.contains(string)) {
                String[] stringArray = new String[objectArray.length * 2];
                for (int j = 0; j < objectArray.length; ++j) {
                    stringArray[j] = (String)objectArray[j] + string;
                    stringArray[j + objectArray.length] = objectArray[j];
                }
                objectArray = stringArray;
                continue;
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                int n3 = n2++;
                objectArray[n3] = (String)objectArray[n3] + string;
            }
        }
        Arrays.sort(objectArray);
        ArrayList<Production> arrayList = new ArrayList<Production>();
        string = production.getLHS();
        int n4 = n = ((String)objectArray[0]).length() == 0 ? 1 : 0;
        while (n < objectArray.length) {
            arrayList.add(new Production(string, (String)objectArray[n]));
            ++n;
        }
        return arrayList.toArray(new Production[0]);
    }

    public Production[] getProductionsToAddToGrammar(Grammar grammar, Set set) {
        ArrayList<Production> arrayList = new ArrayList<Production>();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            Production[] productionArray2 = this.getProductionsToAddForProduction(productionArray[i], set);
            for (int j = 0; j < productionArray2.length; ++j) {
                arrayList.add(productionArray2[j]);
            }
        }
        return arrayList.toArray(new Production[0]);
    }

    public Production[] getNonLambdaProductions(Grammar grammar) {
        ProductionChecker productionChecker = new ProductionChecker();
        ArrayList<Production> arrayList = new ArrayList<Production>();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (ProductionChecker.isLambdaProduction(productionArray[i])) continue;
            arrayList.add(productionArray[i]);
        }
        return arrayList.toArray(new Production[0]);
    }

    public Grammar getLambdaProductionlessGrammar(Grammar grammar, Set set) {
        ContextFreeGrammar contextFreeGrammar = new ContextFreeGrammar();
        contextFreeGrammar.addProductions(this.getProductionsToAddToGrammar(grammar, set));
        return contextFreeGrammar;
    }

    private boolean isNotReplacedByLambda(char c, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (c != string.charAt(i)) continue;
            return true;
        }
        return false;
    }

    private Production getProductionForCombination(Production production, String string) {
        ProductionChecker productionChecker = new ProductionChecker();
        String string2 = production.getRHS();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (!ProductionChecker.isTerminal(c) && !this.isNotReplacedByLambda(c, string)) continue;
            stringBuffer.append(c);
        }
        Production production2 = new Production(production.getLHS(), stringBuffer.toString());
        return production2;
    }

    private String getRepresentation(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != this.ONE_CHAR) continue;
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private String pad(String string, int n) {
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            string = this.ZERO.concat(string);
        }
        return string;
    }

    private String[] getCombinations(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < (int)Math.pow(2.0, stringArray.length); ++i) {
            String string = this.pad(Integer.toBinaryString(i), stringArray.length);
            arrayList.add(this.getRepresentation(string, stringArray));
        }
        return arrayList.toArray(new String[0]);
    }
}

