/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import automata.fsa.FiniteStateAutomaton;
import automata.mealy.MealyMachine;
import automata.mealy.MooreMachine;
import automata.pda.PushdownAutomaton;
import automata.turing.TuringMachine;
import file.xml.CFPumpingLemmaTransducer;
import file.xml.FSATransducer;
import file.xml.GrammarTransducer;
import file.xml.LSystemTransducer;
import file.xml.MealyTransducer;
import file.xml.MooreTransducer;
import file.xml.PDATransducer;
import file.xml.RETransducer;
import file.xml.RegPumpingLemmaTransducer;
import file.xml.TMTransducer;
import file.xml.Transducer;
import grammar.Grammar;
import grammar.lsystem.LSystem;
import gui.pumping.CFPumpingLemmaChooser;
import gui.pumping.RegPumpingLemmaChooser;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import regular.RegularExpression;

public class TransducerFactory {
    private static Map typeToTransducer = new HashMap();
    private static Map classToTransducer = new HashMap();

    public static Transducer getTransducer(Document document) {
        Object v;
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("type");
        if (nodeList.getLength() == 0) {
            throw new IllegalArgumentException("No <type> tag appears to exist!");
        }
        Node node = nodeList.item(0);
        NodeList nodeList2 = node.getChildNodes();
        String string = "";
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node2 = nodeList2.item(i);
            if (node2.getNodeType() != 3) continue;
            string = ((Text)node2).getData();
            break;
        }
        if ((v = typeToTransducer.get(string)) == null) {
            throw new IllegalArgumentException("The type \"" + string + "\" is not recognized.");
        }
        return TransducerFactory.instantiate(v);
    }

    public static Transducer getTransducer(Serializable serializable) {
        for (Class<?> clazz = serializable.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Object v = classToTransducer.get(clazz);
            if (v == null) continue;
            return TransducerFactory.instantiate(v);
        }
        throw new IllegalArgumentException("Cannot get transducer for object of " + serializable.getClass() + "!");
    }

    private static Transducer instantiate(Object object) {
        if (object instanceof Class) {
            try {
                return (Transducer)((Class)object).newInstance();
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("Could not instantiate " + object + "!");
            }
        }
        if (object instanceof Transducer) {
            return (Transducer)object;
        }
        throw new IllegalArgumentException("Object " + object + " does not correspond to a transducer!");
    }

    private static void add(String string, Class clazz, Object object) {
        if (string == null) {
            string = ((Transducer)object).getType();
        }
        typeToTransducer.put(string, object);
        classToTransducer.put(clazz, object);
    }

    static {
        TransducerFactory.add(null, FiniteStateAutomaton.class, new FSATransducer());
        TransducerFactory.add(null, PushdownAutomaton.class, new PDATransducer());
        TransducerFactory.add(null, TuringMachine.class, new TMTransducer());
        TransducerFactory.add(null, Grammar.class, new GrammarTransducer());
        TransducerFactory.add(null, RegularExpression.class, new RETransducer());
        TransducerFactory.add(null, LSystem.class, new LSystemTransducer());
        TransducerFactory.add(null, MealyMachine.class, new MealyTransducer());
        TransducerFactory.add(null, MooreMachine.class, new MooreTransducer());
        TransducerFactory.add(null, RegPumpingLemmaChooser.class, new RegPumpingLemmaTransducer());
        TransducerFactory.add(null, CFPumpingLemmaChooser.class, new CFPumpingLemmaTransducer());
    }
}

