/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.turing.TMTransition;
import automata.turing.TuringMachine;
import file.DataException;
import file.xml.AutomatonTransducer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TMTransducer
extends AutomatonTransducer {
    public static final String TURING_TAPES_NAME = "tapes";
    public static final String TRANSITION_TAPE_NAME = "tape";
    public static final String TRANSITION_READ_NAME = "read";
    public static final String TRANSITION_WRITE_NAME = "write";
    public static final String TRANSITION_MOVE_NAME = "move";
    public static final String IS_BLOCK = "block";

    @Override
    protected Automaton createEmptyAutomaton(Document document) {
        Map map = TMTransducer.elementsToText(document.getDocumentElement());
        String string = (String)map.get(TURING_TAPES_NAME);
        if (string == null) {
            string = "1";
        }
        try {
            int n = Integer.parseInt(string);
            if (n < 1 || n > 5) {
                throw new DataException(n + " invalid # of tapes.  Valid # of tapes 1-5.");
            }
            return new TuringMachine(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataException("Error reading " + string + " as number of tapes.");
        }
    }

    @Override
    protected Transition createTransition(State state, State state2, Node node, Map map, boolean bl) {
        TuringMachine turingMachine = (TuringMachine)state.getAutomaton();
        int n = turingMachine.tapes();
        Object[] objectArray = new String[n];
        Object[] objectArray2 = new String[n];
        Object[] objectArray3 = new String[n];
        Arrays.fill(objectArray, "");
        Arrays.fill(objectArray2, "");
        Arrays.fill(objectArray3, "R");
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        hashMap.put(TRANSITION_READ_NAME, objectArray);
        hashMap.put(TRANSITION_WRITE_NAME, objectArray2);
        hashMap.put(TRANSITION_MOVE_NAME, objectArray3);
        for (Object object : hashMap.keySet()) {
            String[] stringArray = (String[])hashMap.get(object);
            NodeList nodeList = ((Element)node).getElementsByTagName((String)object);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string = element.getAttribute(TRANSITION_TAPE_NAME);
                if (string.length() == 0) {
                    string = "1";
                }
                int n2 = 1;
                try {
                    n2 = Integer.parseInt(string);
                    if (n2 < 1 || n2 > n) {
                        throw new DataException("In " + (String)object + " tag, tape " + n2 + " identified but only 1-" + n + " are valid.");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataException("In " + (String)object + " tag, error reading " + string + " as tape.");
                }
                String string2 = TMTransducer.containedText(element);
                if (string2 == null) {
                    string2 = "";
                }
                stringArray[n2 - 1] = string2;
                if (!bl) continue;
                for (int j = 0; j < objectArray2.length; ++j) {
                    objectArray2[i] = "~";
                    objectArray3[i] = "S";
                }
            }
        }
        try {
            Object object;
            object = new TMTransition(state, state2, (String[])objectArray, (String[])objectArray2, (String[])objectArray3);
            if (bl) {
                ((TMTransition)object).setBlockTransition(true);
            }
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataException(illegalArgumentException.getMessage());
        }
    }

    @Override
    protected Element createTransitionElement(Document document, Transition transition) {
        Element element = super.createTransitionElement(document, transition);
        TMTransition tMTransition = (TMTransition)transition;
        TuringMachine turingMachine = (TuringMachine)tMTransition.getFromState().getAutomaton();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < turingMachine.tapes(); ++i) {
            if (turingMachine.tapes() > 1) {
                hashMap.put(TRANSITION_TAPE_NAME, "" + (i + 1));
            }
            String string = tMTransition.getRead(i);
            String string2 = tMTransition.getWrite(i);
            if (string.equals("\u25a1")) {
                string = "";
            }
            if (string2.equals("\u25a1")) {
                string2 = "";
            }
            element.appendChild(TMTransducer.createElement(document, TRANSITION_READ_NAME, hashMap, string));
            if (tMTransition.isBlockTransition()) {
                element.setAttribute(IS_BLOCK, "true");
                return element;
            }
            element.appendChild(TMTransducer.createElement(document, TRANSITION_WRITE_NAME, hashMap, string2));
            element.appendChild(TMTransducer.createElement(document, TRANSITION_MOVE_NAME, hashMap, tMTransition.getDirection(i)));
        }
        return element;
    }

    @Override
    public String getType() {
        return "turing";
    }

    @Override
    public Document toDOM(Serializable serializable) {
        Document document = super.toDOM(serializable);
        TuringMachine turingMachine = (TuringMachine)serializable;
        if (turingMachine.tapes() > 1) {
            Element element = TMTransducer.createElement(document, TURING_TAPES_NAME, null, "" + turingMachine.tapes());
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            if (nodeList.getLength() == 1) {
                document.getDocumentElement().appendChild(element);
            } else {
                document.getDocumentElement().insertBefore(element, nodeList.item(1));
            }
        }
        return document;
    }
}

