/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import file.xml.PumpingLemmaFactory;
import file.xml.PumpingLemmaTransducer;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pumping.Case;
import pumping.ContextFreePumpingLemma;

public class CFPumpingLemmaTransducer
extends PumpingLemmaTransducer {
    public static String TYPE = "context-free pumping lemma";
    public static String U_NAME = "uLength";
    public static String V_NAME = "vLength";
    public static String X_NAME = "xLength";
    public static String Y_NAME = "yLength";
    public static String CASE_NAME = "case";
    public static String CASE_I_NAME = "caseI";
    public static String CASE_U_NAME = "caseULength";
    public static String CASE_V_NAME = "caseVLength";
    public static String CASE_X_NAME = "caseXLength";
    public static String CASE_Y_NAME = "caseYLength";

    @Override
    public Serializable fromDOM(Document document) {
        int n;
        ContextFreePumpingLemma contextFreePumpingLemma = (ContextFreePumpingLemma)PumpingLemmaFactory.createPumpingLemma(TYPE, document.getElementsByTagName(LEMMA_NAME).item(0).getTextContent());
        contextFreePumpingLemma.setM(Integer.parseInt(document.getElementsByTagName(M_NAME).item(0).getTextContent()));
        contextFreePumpingLemma.setW(document.getElementsByTagName(W_NAME).item(0).getTextContent());
        contextFreePumpingLemma.setI(Integer.parseInt(document.getElementsByTagName(I_NAME).item(0).getTextContent()));
        this.readCases(document, contextFreePumpingLemma);
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(ATTEMPT);
        for (n = 0; n < nodeList.getLength(); ++n) {
            contextFreePumpingLemma.addAttempt(nodeList.item(n).getTextContent());
        }
        contextFreePumpingLemma.setFirstPlayer(document.getElementsByTagName(FIRST_PLAYER).item(0).getTextContent());
        n = Integer.parseInt(document.getElementsByTagName(U_NAME).item(0).getTextContent());
        int n2 = Integer.parseInt(document.getElementsByTagName(V_NAME).item(0).getTextContent());
        int n3 = Integer.parseInt(document.getElementsByTagName(X_NAME).item(0).getTextContent());
        int n4 = Integer.parseInt(document.getElementsByTagName(Y_NAME).item(0).getTextContent());
        contextFreePumpingLemma.setDecomposition(new int[]{n, n2, n3, n4});
        return contextFreePumpingLemma;
    }

    protected void readCases(Document document, ContextFreePumpingLemma contextFreePumpingLemma) {
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(CASE_NAME);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            int n = Integer.parseInt(((Element)node).getElementsByTagName(CASE_U_NAME).item(0).getTextContent());
            int n2 = Integer.parseInt(((Element)node).getElementsByTagName(CASE_V_NAME).item(0).getTextContent());
            int n3 = Integer.parseInt(((Element)node).getElementsByTagName(CASE_X_NAME).item(0).getTextContent());
            int n4 = Integer.parseInt(((Element)node).getElementsByTagName(CASE_Y_NAME).item(0).getTextContent());
            int n5 = Integer.parseInt(((Element)node).getElementsByTagName(CASE_I_NAME).item(0).getTextContent());
            contextFreePumpingLemma.addCase(new int[]{n, n2, n3, n4}, n5);
        }
    }

    @Override
    public Document toDOM(Serializable serializable) {
        ArrayList arrayList;
        ContextFreePumpingLemma contextFreePumpingLemma = (ContextFreePumpingLemma)serializable;
        Document document = this.newEmptyDocument();
        Element element = document.getDocumentElement();
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, LEMMA_NAME, null, contextFreePumpingLemma.getTitle()));
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, FIRST_PLAYER, null, contextFreePumpingLemma.getFirstPlayer()));
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, M_NAME, null, "" + contextFreePumpingLemma.getM()));
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, W_NAME, null, "" + contextFreePumpingLemma.getW()));
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, I_NAME, null, "" + contextFreePumpingLemma.getI()));
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, U_NAME, null, "" + contextFreePumpingLemma.getU().length()));
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, V_NAME, null, "" + contextFreePumpingLemma.getV().length()));
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, X_NAME, null, "" + contextFreePumpingLemma.getX().length()));
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, Y_NAME, null, "" + contextFreePumpingLemma.getY().length()));
        ArrayList arrayList2 = contextFreePumpingLemma.getAttempts();
        if (arrayList2 != null && arrayList2.size() > 0) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                element.appendChild(CFPumpingLemmaTransducer.createElement(document, ATTEMPT, null, (String)arrayList2.get(i)));
            }
        }
        if ((arrayList = contextFreePumpingLemma.getDoneCases()) != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                element.appendChild(this.createCaseElement(document, (Case)arrayList.get(i)));
            }
        }
        return document;
    }

    protected Element createCaseElement(Document document, Case case_) {
        Element element = CFPumpingLemmaTransducer.createElement(document, CASE_NAME, null, null);
        int[] nArray = case_.getInput();
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, CASE_U_NAME, null, "" + nArray[0]));
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, CASE_V_NAME, null, "" + nArray[1]));
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, CASE_X_NAME, null, "" + nArray[2]));
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, CASE_Y_NAME, null, "" + nArray[3]));
        element.appendChild(CFPumpingLemmaTransducer.createElement(document, CASE_I_NAME, null, "" + case_.getI()));
        return element;
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

