/*
 * Decompiled with CFR 0.152.
 */
package file;

import file.Codec;
import file.EncodeException;
import file.Encoder;
import file.ParseException;
import file.XMLCodec;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;

public class SerializedCodec
extends Codec {
    private XMLCodec xmlcodec;

    public SerializedCodec(XMLCodec xMLCodec) {
        this.xmlcodec = xMLCodec;
    }

    @Override
    public Serializable decode(File file, Map map) {
        Serializable serializable = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            serializable = (Serializable)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            throw new ParseException("Could not open file to read!");
        }
        catch (ClassCastException classCastException) {
            throw new ParseException("Bad Class Read!");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParseException("Unrecognized Class Read!");
        }
        return serializable;
    }

    @Override
    public File encode(Serializable serializable, File file, Map map) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectOutputStream.close();
            return file;
        }
        catch (NotSerializableException notSerializableException) {
            throw new EncodeException("Object Not Serializable");
        }
        catch (IOException iOException) {
            throw new EncodeException("Could not open file to write!");
        }
    }

    @Override
    public boolean canEncode(Serializable serializable) {
        return false;
    }

    @Override
    public String getDescription() {
        return "JFLAP 4 Beta File";
    }

    @Override
    public Encoder correspondingEncoder() {
        return this.xmlcodec;
    }
}

