/*
 * Decompiled with CFR 0.152.
 */
package automata.pda;

import automata.State;
import automata.Transition;
import automata.pda.PushdownAutomaton;
import gui.environment.Universe;

public class PDATransition
extends Transition {
    protected String myInputToRead;
    protected String myStringToPop;
    protected String myStringToPush;

    public PDATransition(State state, State state2, String string, String string2, String string3) {
        super(state, state2);
        this.setInputToRead(string);
        this.setStringToPop(string2);
        this.setStringToPush(string3);
    }

    @Override
    public Transition copy(State state, State state2) {
        return new PDATransition(state, state2, this.getInputToRead(), this.getStringToPop(), this.getStringToPush());
    }

    public String getInputToRead() {
        return this.myInputToRead;
    }

    protected void setInputToRead(String string) {
        this.myInputToRead = string;
    }

    public String getStringToPop() {
        return this.myStringToPop;
    }

    protected void setStringToPop(String string) {
        PushdownAutomaton pushdownAutomaton = (PushdownAutomaton)this.getAutomaton();
        if (pushdownAutomaton.singleInputPDA && string.length() > 1) {
            throw new IllegalArgumentException("Pop string must have no more than one character!");
        }
        this.myStringToPop = string;
    }

    public String getStringToPush() {
        return this.myStringToPush;
    }

    protected void setStringToPush(String string) {
        PushdownAutomaton pushdownAutomaton = (PushdownAutomaton)this.getAutomaton();
        if (pushdownAutomaton.singleInputPDA && string.length() > 1) {
            throw new IllegalArgumentException("Push string must have no more than one character!");
        }
        this.myStringToPush = string;
    }

    @Override
    public String getDescription() {
        String string;
        String string2;
        String string3 = this.getInputToRead();
        if (string3.length() == 0) {
            string3 = Universe.curProfile.getEmptyString();
        }
        if ((string2 = this.getStringToPop()).length() == 0) {
            string2 = Universe.curProfile.getEmptyString();
        }
        if ((string = this.getStringToPush()).length() == 0) {
            string = Universe.curProfile.getEmptyString();
        }
        return string3 + " , " + string2 + " ; " + string;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.myInputToRead.hashCode() ^ this.myStringToPop.hashCode() ^ this.myStringToPush.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        try {
            PDATransition pDATransition = (PDATransition)object;
            return super.equals(object) && this.myInputToRead.equals(pDATransition.myInputToRead) && this.myStringToPop.equals(pDATransition.myStringToPop) && this.myStringToPush.equals(pDATransition.myStringToPush);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public String toString() {
        return super.toString() + ": \"" + this.getInputToRead() + "\"" + ": \"" + this.getStringToPop() + "\"" + ": \"" + this.getStringToPush() + "\"";
    }
}

