/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.CircleChain;
import automata.graph.layout.RandomLayoutAlgorithm;
import automata.graph.layout.VertexChain;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TwoCircleLayoutAlgorithm
extends LayoutAlgorithm {
    public Graph graph;
    ArrayList vertices;
    ArrayList innerCircle;
    ArrayList outerCircle;
    CircleChain[] outerCircleChains;
    CircleChain innerCircleChain;

    public TwoCircleLayoutAlgorithm() {
    }

    public TwoCircleLayoutAlgorithm(Dimension dimension, Dimension dimension2, double d) {
        super(dimension, dimension2, d);
    }

    @Override
    public void layout(Graph graph, Set set) {
        this.graph = graph;
        this.innerCircle = new ArrayList();
        this.outerCircle = new ArrayList();
        this.vertices = TwoCircleLayoutAlgorithm.getMovableVertices(this.graph, set);
        if (this.graph == null || this.vertices.size() == 0) {
            return;
        }
        this.assignToCircles();
        this.innerCircleChain = new CircleChain(this.graph, this.vertexDim, this.vertexBuffer);
        for (int i = 0; i < this.innerCircle.size(); ++i) {
            this.innerCircleChain.addVertex(this.innerCircle.get(i));
        }
        this.innerCircleChain.layout(0.0, Math.PI, Math.PI * 2);
        this.innerCircle = this.innerCircleChain.getVertices();
        if (this.outerCircle.size() > 0) {
            this.createOuterCircleChains();
            this.shuffleOuterChains();
            double d = this.innerCircleChain.getRadius();
            double d2 = Math.PI * 2 / (double)this.outerCircleChains.length;
            double d3 = d2 * 4.0 / 5.0;
            for (int i = 0; i < this.outerCircleChains.length; ++i) {
                this.outerCircleChains[i].layout(d, d2 * (double)i, d3);
            }
        }
        TwoCircleLayoutAlgorithm.polarToCartesian(this.graph, this.vertices);
        TwoCircleLayoutAlgorithm.shiftOntoScreen(this.graph, this.size, this.vertexDim, true);
    }

    protected void assignToCircles() {
        int n;
        for (n = 0; n < this.vertices.size(); ++n) {
            if (this.graph.degree(this.vertices.get(n)) > 2) {
                this.innerCircle.add(this.vertices.get(n));
                continue;
            }
            this.outerCircle.add(this.vertices.get(n));
        }
        if (this.innerCircle.size() == 0) {
            this.innerCircle = this.outerCircle;
            this.outerCircle = new ArrayList();
            return;
        }
        do {
            n = 0;
            for (int i = 0; i < this.outerCircle.size(); ++i) {
                int n2 = 0;
                for (int j = 0; j < this.innerCircle.size(); ++j) {
                    if (!this.graph.hasEdge(this.outerCircle.get(i), this.innerCircle.get(j))) continue;
                    ++n2;
                }
                if (n2 < 2) continue;
                this.innerCircle.add(this.outerCircle.get(i));
                this.outerCircle.remove(i);
                n = 1;
            }
        } while (n != 0);
    }

    protected void createOuterCircleChains() {
        int n;
        int n2;
        int n3;
        int n4;
        this.outerCircleChains = new CircleChain[this.innerCircle.size()];
        int[] nArray = new int[this.outerCircle.size()];
        for (n4 = 0; n4 < this.outerCircleChains.length; ++n4) {
            this.outerCircleChains[n4] = new CircleChain(this.graph, this.vertexDim, this.vertexBuffer);
        }
        for (n4 = 0; n4 < this.outerCircle.size(); ++n4) {
            nArray[n4] = -1;
            for (n3 = 0; n3 < this.innerCircle.size(); ++n3) {
                if (!this.graph.hasEdge(this.outerCircle.get(n4), this.innerCircle.get(n3))) continue;
                this.outerCircleChains[n3].addVertex(this.outerCircle.get(n4));
                nArray[n4] = n3;
            }
        }
        boolean bl = false;
        do {
            bl = false;
            for (n2 = 0; n2 < this.outerCircle.size(); ++n2) {
                if (nArray[n2] != -1) continue;
                n4 = -1;
                n3 = -1;
                for (int i = 0; i < this.outerCircleChains.length; ++i) {
                    if (!this.outerCircleChains[i].isEdgeToChainMember(this.outerCircle.get(n2)) || nArray[n2] != -1) continue;
                    if (n4 == -1) {
                        n4 = i;
                        continue;
                    }
                    n3 = i;
                }
                if (n4 > -1 && n3 == -1) {
                    this.outerCircleChains[n4].addVertex(this.outerCircle.get(n2));
                    nArray[n2] = n4;
                    bl = true;
                    continue;
                }
                if (n4 <= -1 || n3 <= -1) continue;
                n = this.outerCircleChains[n4].size() < this.outerCircleChains[n3].size() ? n4 : n3;
                this.outerCircleChains[n].addVertex(this.outerCircle.get(n2));
                nArray[n2] = n;
                bl = true;
            }
        } while (bl);
        n = 0;
        for (n2 = 0; n2 < this.outerCircleChains.length; ++n2) {
            if (this.outerCircleChains[n].getVertices().size() <= this.outerCircleChains[n2].getVertices().size()) continue;
            n = n2;
        }
        for (n2 = 0; n2 < this.outerCircle.size(); ++n2) {
            if (nArray[n2] != -1) continue;
            this.outerCircleChains[n].addVertex(this.outerCircle.get(n2));
        }
    }

    protected void shuffleOuterChains() {
        for (int i = 0; i < this.outerCircleChains.length; ++i) {
            CircleChain circleChain = this.outerCircleChains[i];
            CircleChain circleChain2 = i < this.outerCircleChains.length - 1 ? this.outerCircleChains[i + 1] : this.outerCircleChains[0];
            VertexChain.alignTwoChains(circleChain, circleChain2, this.graph);
        }
    }

    public static void main(String[] stringArray) {
        int n;
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        jFrame.setSize(900, 900);
        jFrame.setContentPane(jPanel);
        jFrame.setLocationRelativeTo(null);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
        String[] stringArray2 = new String[20];
        Graph graph = new Graph();
        RandomLayoutAlgorithm randomLayoutAlgorithm = new RandomLayoutAlgorithm();
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = "V" + i;
            graph.addVertex(stringArray2[i], new Point2D.Double(0.0, 0.0));
            if (i <= 0) continue;
            graph.addEdge(stringArray2[i], stringArray2[i - 1]);
        }
        HashSet hashSet = new HashSet();
        ((LayoutAlgorithm)randomLayoutAlgorithm).layout(graph, hashSet);
        for (n = 0; n < stringArray2.length; ++n) {
            Point2D point2D = graph.pointForVertex(stringArray2[n]);
            jPanel.getGraphics().drawString(stringArray2[n], (int)point2D.getX(), (int)point2D.getY() - 10);
            jPanel.getGraphics().fillRect((int)point2D.getX(), (int)point2D.getY(), 30, 30);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!graph.hasEdge(stringArray2[n], stringArray2[i])) continue;
                jPanel.getGraphics().drawLine((int)graph.pointForVertex(stringArray2[n]).getX(), (int)graph.pointForVertex(stringArray2[n]).getY(), (int)graph.pointForVertex(stringArray2[i]).getX(), (int)graph.pointForVertex(stringArray2[i]).getY());
            }
        }
        jPanel.revalidate();
    }
}

