/*
 * Decompiled with CFR 0.152.
 */
package automata.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Graph {
    protected Map verticesToPoints = new HashMap();
    protected Map verticesToNeighbors = new HashMap();

    public void clear() {
        this.verticesToPoints.clear();
        this.verticesToNeighbors.clear();
    }

    public int degree(Object object) {
        return this.adjacent(object).size();
    }

    public int numberOfVertices() {
        return this.verticesToPoints.size();
    }

    public Set adjacent(Object object) {
        if (!this.verticesToNeighbors.containsKey(object)) {
            this.verticesToNeighbors.put(object, new HashSet());
        }
        return (Set)this.verticesToNeighbors.get(object);
    }

    public void addEdge(Object object, Object object2) {
        this.adjacent(object).add(object2);
        this.adjacent(object2).add(object);
    }

    public void removeEdge(Object object, Object object2) {
        this.adjacent(object).remove(object2);
        this.adjacent(object2).remove(object);
    }

    public boolean hasEdge(Object object, Object object2) {
        return this.adjacent(object).contains(object2);
    }

    public void addVertex(Object object, Point2D point2D) {
        this.verticesToPoints.put(object, point2D.clone());
    }

    public void removeVertex(Object object) {
        Set set = this.adjacent(object);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.adjacent(iterator.next()).remove(object);
        }
        this.verticesToNeighbors.remove(object);
        this.verticesToPoints.remove(object);
    }

    public void moveVertex(Object object, Point2D point2D) {
        this.addVertex(object, point2D);
    }

    public Point2D pointForVertex(Object object) {
        return (Point2D)this.verticesToPoints.get(object);
    }

    public Object[] vertices() {
        return this.verticesToPoints.keySet().toArray();
    }

    public Point2D[] points() {
        return this.verticesToPoints.values().toArray(new Point2D[0]);
    }

    public void moveWithinFrame(Rectangle2D rectangle2D) {
        int n;
        Object[] objectArray = this.vertices();
        if (objectArray.length == 0) {
            return;
        }
        Point2D point2D = this.pointForVertex(objectArray[0]);
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = d;
        double d4 = d2;
        for (n = 1; n < objectArray.length; ++n) {
            point2D = this.pointForVertex(objectArray[n]);
            d = Math.min(d, point2D.getX());
            d2 = Math.min(d2, point2D.getY());
            d3 = Math.max(d3, point2D.getX());
            d4 = Math.max(d4, point2D.getY());
        }
        for (n = 0; n < objectArray.length; ++n) {
            point2D = this.pointForVertex(objectArray[n]);
            point2D = new Point2D.Double((point2D.getX() - d) * rectangle2D.getWidth() / (d3 - d) + rectangle2D.getX(), (point2D.getY() - d2) * rectangle2D.getHeight() / (d4 - d2) + rectangle2D.getY());
            this.moveVertex(objectArray[n], point2D);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append(this.verticesToPoints);
        return stringBuffer.toString();
    }
}

