/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.AlphabetRetriever;
import automata.Automaton;
import automata.AutomatonChecker;
import automata.ClosureTaker;
import automata.State;
import automata.StatePlacer;
import automata.Transition;
import automata.fsa.FSAAlphabetRetriever;
import automata.fsa.FSALabelHandler;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;

public class NFAToDFA {
    public State createInitialState(Automaton automaton, Automaton automaton2) {
        State state = automaton.getInitialState();
        State[] stateArray = ClosureTaker.getClosure(state, automaton);
        State state2 = this.createStateWithStates(automaton2, stateArray, automaton);
        automaton2.setInitialState(state2);
        return state2;
    }

    public boolean hasFinalState(State[] stateArray, Automaton automaton) {
        for (int i = 0; i < stateArray.length; ++i) {
            if (!automaton.isFinalState(stateArray[i])) continue;
            return true;
        }
        return false;
    }

    public State[] getStatesForState(State state, Automaton automaton) {
        if (state.getLabel() == null) {
            return new State[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(state.getLabel(), " \t\n\r\f,q");
        ArrayList<State> arrayList = new ArrayList<State>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(automaton.getStateWithID(Integer.parseInt(stringTokenizer.nextToken())));
        }
        return arrayList.toArray(new State[0]);
    }

    public String getStringForStates(State[] stateArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stateArray.length - 1; ++i) {
            stringBuffer.append(Integer.toString(stateArray[i].getID()));
            stringBuffer.append(",");
        }
        stringBuffer.append(Integer.toString(stateArray[stateArray.length - 1].getID()));
        return stringBuffer.toString();
    }

    public State[] getStatesOnTerminal(String string, State[] stateArray, Automaton automaton) {
        ArrayList<State> arrayList = new ArrayList<State>();
        for (int i = 0; i < stateArray.length; ++i) {
            State state = stateArray[i];
            Transition[] transitionArray = automaton.getTransitionsFromState(state);
            for (int j = 0; j < transitionArray.length; ++j) {
                FSATransition fSATransition = (FSATransition)transitionArray[j];
                if (!fSATransition.getLabel().equals(string)) continue;
                State state2 = fSATransition.getToState();
                State[] stateArray2 = ClosureTaker.getClosure(state2, automaton);
                for (int k = 0; k < stateArray2.length; ++k) {
                    if (arrayList.contains(stateArray2[k])) continue;
                    arrayList.add(stateArray2[k]);
                }
            }
        }
        return arrayList.toArray(new State[0]);
    }

    private boolean containsState(State state, State[] stateArray) {
        for (int i = 0; i < stateArray.length; ++i) {
            if (stateArray[i] != state) continue;
            return true;
        }
        return false;
    }

    public boolean containSameStates(State[] stateArray, State[] stateArray2) {
        int n = stateArray.length;
        int n2 = stateArray2.length;
        if (n != n2) {
            return false;
        }
        Arrays.sort(stateArray, new Comparator<State>(){

            @Override
            public int compare(State state, State state2) {
                return state.hashCode() - state2.hashCode();
            }
        });
        Arrays.sort(stateArray2, new Comparator<State>(){

            @Override
            public int compare(State state, State state2) {
                return state.hashCode() - state2.hashCode();
            }
        });
        for (int i = 0; i < stateArray.length; ++i) {
            if (stateArray[i] == stateArray2[i]) continue;
            return false;
        }
        return true;
    }

    public State getStateForStates(State[] stateArray, Automaton automaton, Automaton automaton2) {
        State[] stateArray2 = automaton.getStates();
        for (int i = 0; i < stateArray2.length; ++i) {
            State[] stateArray3 = this.getStatesForState(stateArray2[i], automaton2);
            if (!this.containSameStates(stateArray3, stateArray)) continue;
            return stateArray2[i];
        }
        return null;
    }

    public ArrayList expandState(State state, Automaton automaton, Automaton automaton2) {
        ArrayList<State> arrayList = new ArrayList<State>();
        FSAAlphabetRetriever fSAAlphabetRetriever = new FSAAlphabetRetriever();
        String[] stringArray = ((AlphabetRetriever)fSAAlphabetRetriever).getAlphabet(automaton);
        for (int i = 0; i < stringArray.length; ++i) {
            State[] stateArray = this.getStatesOnTerminal(stringArray[i], this.getStatesForState(state, automaton), automaton);
            if (stateArray.length <= 0) continue;
            State state2 = this.getStateForStates(stateArray, automaton2, automaton);
            if (state2 == null) {
                state2 = this.createStateWithStates(automaton2, stateArray, automaton);
                arrayList.add(state2);
            }
            FSATransition fSATransition = new FSATransition(state, state2, stringArray[i]);
            automaton2.addTransition(fSATransition);
        }
        return arrayList;
    }

    public State createStateWithStates(Automaton automaton, State[] stateArray, Automaton automaton2) {
        StatePlacer statePlacer = new StatePlacer();
        State state = automaton.createState(statePlacer.getPointForState(automaton));
        state.setLabel(this.getStringForStates(stateArray));
        if (this.hasFinalState(stateArray, automaton2)) {
            automaton.addFinalState(state);
        }
        return state;
    }

    public FiniteStateAutomaton convertToDFA(Automaton automaton) {
        AutomatonChecker automatonChecker = new AutomatonChecker();
        if (!automatonChecker.isNFA(automaton)) {
            return (FiniteStateAutomaton)automaton.clone();
        }
        if (FSALabelHandler.hasMultipleCharacterLabels(automaton)) {
            FSALabelHandler.removeMultipleCharacterLabelsFromAutomaton(automaton);
        }
        FiniteStateAutomaton finiteStateAutomaton = new FiniteStateAutomaton();
        State state = this.createInitialState(automaton, finiteStateAutomaton);
        ArrayList<State> arrayList = new ArrayList<State>();
        arrayList.add(state);
        while (!arrayList.isEmpty()) {
            ArrayList arrayList2 = new ArrayList();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                State state2 = (State)iterator.next();
                arrayList2.addAll(this.expandState(state2, automaton, finiteStateAutomaton));
                iterator.remove();
            }
            arrayList.addAll(arrayList2);
        }
        return finiteStateAutomaton;
    }
}

