/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.AlphabetRetriever;
import automata.Automaton;
import automata.AutomatonChecker;
import automata.State;
import automata.StatePlacer;
import automata.Transition;
import automata.UnreachableStatesDetector;
import automata.fsa.FSAAlphabetRetriever;
import automata.fsa.FSALabelHandler;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import automata.fsa.MinimizeTreeNode;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class Minimizer {
    protected HashMap MAP;
    protected State TRAP_STATE;

    public void initializeMinimizer() {
        this.MAP = new HashMap();
        this.TRAP_STATE = null;
    }

    public String getString(State[] stateArray) {
        if (stateArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stateArray.length - 1; ++i) {
            stringBuffer.append(Integer.toString(stateArray[i].getID()));
            stringBuffer.append(",");
        }
        stringBuffer.append(Integer.toString(stateArray[stateArray.length - 1].getID()));
        return stringBuffer.toString();
    }

    public String getTerminalToSplit(State[] stateArray, Automaton automaton, DefaultTreeModel defaultTreeModel) {
        FSAAlphabetRetriever fSAAlphabetRetriever = new FSAAlphabetRetriever();
        String[] stringArray = ((AlphabetRetriever)fSAAlphabetRetriever).getAlphabet(automaton);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isSplittableOnTerminal(stateArray, stringArray[i], automaton, defaultTreeModel)) continue;
            return stringArray[i];
        }
        return null;
    }

    public boolean isSplittableOnTerminal(State[] stateArray, String string, Automaton automaton, DefaultTreeModel defaultTreeModel) {
        return this.getGroupsFromGroupOnTerminal(stateArray, string, automaton, defaultTreeModel).size() > 1;
    }

    public boolean isSplittable(State[] stateArray, Automaton automaton, DefaultTreeModel defaultTreeModel) {
        if (stateArray.length <= 1) {
            return false;
        }
        FSAAlphabetRetriever fSAAlphabetRetriever = new FSAAlphabetRetriever();
        String[] stringArray = ((AlphabetRetriever)fSAAlphabetRetriever).getAlphabet(automaton);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isSplittableOnTerminal(stateArray, stringArray[i], automaton, defaultTreeModel)) continue;
            return true;
        }
        return false;
    }

    public State[] getDistinguishableGroup(Automaton automaton, DefaultTreeModel defaultTreeModel) {
        MinimizeTreeNode minimizeTreeNode = (MinimizeTreeNode)defaultTreeModel.getRoot();
        ArrayList arrayList = this.getLeaves(defaultTreeModel, minimizeTreeNode);
        for (State[] stateArray : arrayList) {
            if (!this.isSplittable(stateArray, automaton, defaultTreeModel)) continue;
            return stateArray;
        }
        return null;
    }

    public State[] getGroupForState(State state, DefaultTreeModel defaultTreeModel) {
        MinimizeTreeNode minimizeTreeNode = (MinimizeTreeNode)defaultTreeModel.getRoot();
        ArrayList arrayList = this.getLeaves(defaultTreeModel, minimizeTreeNode);
        for (State[] stateArray : arrayList) {
            for (int i = 0; i < stateArray.length; ++i) {
                if (stateArray[i] != state) continue;
                return stateArray;
            }
        }
        return null;
    }

    public boolean stateGoesToGroupOnTerminal(State state, State[] stateArray, String string, Automaton automaton) {
        for (int i = 0; i < stateArray.length; ++i) {
            Transition[] transitionArray = automaton.getTransitionsFromStateToState(state, stateArray[i]);
            for (int j = 0; j < transitionArray.length; ++j) {
                FSATransition fSATransition = (FSATransition)transitionArray[j];
                String string2 = fSATransition.getLabel();
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList getGroupsFromGroupOnTerminal(State[] stateArray, String string, Automaton automaton, DefaultTreeModel defaultTreeModel) {
        ArrayList<State[]> arrayList = new ArrayList<State[]>();
        for (int i = 0; i < stateArray.length; ++i) {
            if (stateArray[i].getAutomaton() != automaton) {
                System.err.println("BADNESS!  BADNESS!");
            }
            Transition[] transitionArray = automaton.getTransitionsFromState(stateArray[i]);
            for (int j = 0; j < transitionArray.length; ++j) {
                State[] stateArray2;
                FSATransition fSATransition = (FSATransition)transitionArray[j];
                if (!fSATransition.getLabel().equals(string) || arrayList.contains(stateArray2 = this.getGroupForState(transitionArray[j].getToState(), defaultTreeModel))) continue;
                arrayList.add(stateArray2);
            }
        }
        return arrayList;
    }

    public MinimizeTreeNode getTreeNodeForObject(DefaultTreeModel defaultTreeModel, MinimizeTreeNode minimizeTreeNode, State[] stateArray) {
        State[] stateArray2 = (State[])minimizeTreeNode.getUserObject();
        if (stateArray2 == stateArray) {
            return minimizeTreeNode;
        }
        for (int i = 0; i < minimizeTreeNode.getChildCount(); ++i) {
            MinimizeTreeNode minimizeTreeNode2 = this.getTreeNodeForObject(defaultTreeModel, (MinimizeTreeNode)minimizeTreeNode.getChildAt(i), stateArray);
            if (minimizeTreeNode2 == null) continue;
            return minimizeTreeNode2;
        }
        return null;
    }

    public ArrayList splitOnTerminal(State[] stateArray, String string, Automaton automaton, DefaultTreeModel defaultTreeModel) {
        ArrayList<State[]> arrayList = new ArrayList<State[]>();
        MinimizeTreeNode minimizeTreeNode = (MinimizeTreeNode)defaultTreeModel.getRoot();
        ArrayList arrayList2 = this.getLeaves(defaultTreeModel, minimizeTreeNode);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ArrayList<State> arrayList3 = new ArrayList<State>();
            State[] stateArray2 = (State[])iterator.next();
            for (int i = 0; i < stateArray.length; ++i) {
                if (!this.stateGoesToGroupOnTerminal(stateArray[i], stateArray2, string, automaton)) continue;
                arrayList3.add(stateArray[i]);
            }
            if (arrayList3.size() <= 0) continue;
            State[] stateArray3 = arrayList3.toArray(new State[0]);
            arrayList.add(stateArray3);
        }
        return arrayList;
    }

    public boolean isMinimized(Automaton automaton, DefaultTreeModel defaultTreeModel) {
        State[] stateArray = this.getDistinguishableGroup(automaton, defaultTreeModel);
        return stateArray == null;
    }

    public ArrayList split(State[] stateArray, Automaton automaton, DefaultTreeModel defaultTreeModel) {
        String string = this.getTerminalToSplit(stateArray, automaton, defaultTreeModel);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.splitOnTerminal(stateArray, string, automaton, defaultTreeModel));
        return arrayList;
    }

    public boolean isTransitionOnTerminal(Transition[] transitionArray, String string) {
        for (int i = 0; i < transitionArray.length; ++i) {
            FSATransition fSATransition = (FSATransition)transitionArray[i];
            if (!fSATransition.getLabel().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean needsTrapState(Automaton automaton) {
        FSAAlphabetRetriever fSAAlphabetRetriever = new FSAAlphabetRetriever();
        String[] stringArray = ((AlphabetRetriever)fSAAlphabetRetriever).getAlphabet(automaton);
        State[] stateArray = automaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            Transition[] transitionArray = automaton.getTransitionsFromState(stateArray[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                if (this.isTransitionOnTerminal(transitionArray, stringArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    public void addTrapState(Automaton automaton) {
        State state;
        if (!this.needsTrapState(automaton)) {
            return;
        }
        StatePlacer statePlacer = new StatePlacer();
        Point point = statePlacer.getPointForState(automaton);
        this.TRAP_STATE = state = automaton.createState(point);
        FSAAlphabetRetriever fSAAlphabetRetriever = new FSAAlphabetRetriever();
        String[] stringArray = ((AlphabetRetriever)fSAAlphabetRetriever).getAlphabet(automaton);
        State[] stateArray = automaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            Transition[] transitionArray = automaton.getTransitionsFromState(stateArray[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                if (this.isTransitionOnTerminal(transitionArray, stringArray[j])) continue;
                FSATransition fSATransition = new FSATransition(stateArray[i], state, stringArray[j]);
                automaton.addTransition(fSATransition);
            }
        }
    }

    public Automaton getMinimizeableAutomaton(Automaton automaton) {
        AutomatonChecker automatonChecker = new AutomatonChecker();
        if (automatonChecker.isNFA(automaton)) {
            return null;
        }
        UnreachableStatesDetector unreachableStatesDetector = new UnreachableStatesDetector(automaton);
        State[] stateArray = unreachableStatesDetector.getUnreachableStates();
        for (int i = 0; i < stateArray.length; ++i) {
            automaton.removeState(stateArray[i]);
        }
        FSALabelHandler.removeMultipleCharacterLabelsFromAutomaton(automaton);
        this.addTrapState(automaton);
        return automaton;
    }

    public void printNode(MinimizeTreeNode minimizeTreeNode) {
        State[] stateArray = (State[])minimizeTreeNode.getUserObject();
        System.out.print(this.getString(stateArray));
    }

    public void printTree(DefaultTreeModel defaultTreeModel, MinimizeTreeNode minimizeTreeNode) {
        this.printNode(minimizeTreeNode);
        for (int i = 0; i < minimizeTreeNode.getChildCount(); ++i) {
            MinimizeTreeNode minimizeTreeNode2 = (MinimizeTreeNode)minimizeTreeNode.getChildAt(i);
            this.printTree(defaultTreeModel, minimizeTreeNode2);
        }
    }

    public DefaultTreeModel getInitializedTree(Automaton automaton) {
        Object object;
        State[] stateArray = automaton.getStates();
        MinimizeTreeNode minimizeTreeNode = new MinimizeTreeNode(stateArray);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(minimizeTreeNode);
        ArrayList<State> arrayList = new ArrayList<State>();
        for (int i = 0; i < stateArray.length; ++i) {
            if (automaton.isFinalState(stateArray[i])) continue;
            arrayList.add(stateArray[i]);
        }
        State[] stateArray2 = arrayList.toArray(new State[0]);
        int n = 0;
        if (stateArray2.length > 0) {
            object = new MinimizeTreeNode(stateArray2);
            defaultTreeModel.insertNodeInto((MutableTreeNode)object, minimizeTreeNode, n);
            ++n;
        }
        if (((State[])(object = automaton.getFinalStates())).length > 0) {
            MinimizeTreeNode minimizeTreeNode2 = new MinimizeTreeNode(object);
            defaultTreeModel.insertNodeInto(minimizeTreeNode2, minimizeTreeNode, n);
        }
        return defaultTreeModel;
    }

    public void addChildrenToParent(ArrayList arrayList, MinimizeTreeNode minimizeTreeNode, DefaultTreeModel defaultTreeModel) {
        int n = 0;
        for (State[] stateArray : arrayList) {
            MinimizeTreeNode minimizeTreeNode2 = new MinimizeTreeNode(stateArray);
            defaultTreeModel.insertNodeInto(minimizeTreeNode2, minimizeTreeNode, n);
            ++n;
        }
    }

    public DefaultTreeModel getDistinguishableGroupsTree(Automaton automaton) {
        DefaultTreeModel defaultTreeModel = this.getInitializedTree(automaton);
        MinimizeTreeNode minimizeTreeNode = (MinimizeTreeNode)defaultTreeModel.getRoot();
        while (!this.isMinimized(automaton, defaultTreeModel)) {
            State[] stateArray = this.getDistinguishableGroup(automaton, defaultTreeModel);
            ArrayList arrayList = new ArrayList();
            String string = this.getTerminalToSplit(stateArray, automaton, defaultTreeModel);
            arrayList.addAll(this.splitOnTerminal(stateArray, string, automaton, defaultTreeModel));
            MinimizeTreeNode minimizeTreeNode2 = this.getTreeNodeForObject(defaultTreeModel, minimizeTreeNode, stateArray);
            minimizeTreeNode2.setTerminal(string);
            this.addChildrenToParent(arrayList, minimizeTreeNode2, defaultTreeModel);
        }
        return defaultTreeModel;
    }

    public boolean hasFinalState(State[] stateArray, Automaton automaton) {
        for (int i = 0; i < stateArray.length; ++i) {
            if (!automaton.isFinalState(stateArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasInitialState(State[] stateArray, Automaton automaton) {
        State state = automaton.getInitialState();
        for (int i = 0; i < stateArray.length; ++i) {
            if (stateArray[i] != state) continue;
            return true;
        }
        return false;
    }

    public void mapStateToGroup(State state, State[] stateArray) {
        this.MAP.put(state, stateArray);
    }

    public State[] getGroupMappedToState(State state) {
        return (State[])this.MAP.get(state);
    }

    public void createStatesForMinimumDfa(Automaton automaton, Automaton automaton2, DefaultTreeModel defaultTreeModel) {
        MinimizeTreeNode minimizeTreeNode = (MinimizeTreeNode)defaultTreeModel.getRoot();
        ArrayList arrayList = this.getLeaves(defaultTreeModel, minimizeTreeNode);
        StatePlacer statePlacer = new StatePlacer();
        for (State[] stateArray : arrayList) {
            if (this.containsTrapState(stateArray)) continue;
            Point point = statePlacer.getPointForState(automaton2);
            State state = automaton2.createState(point);
            state.setLabel(this.getString(stateArray));
            if (this.hasInitialState(stateArray, automaton)) {
                automaton2.setInitialState(state);
            }
            if (this.hasFinalState(stateArray, automaton)) {
                automaton2.addFinalState(state);
            }
            this.mapStateToGroup(state, stateArray);
        }
    }

    public State getStateMappedToGroup(State[] stateArray, Automaton automaton) {
        State[] stateArray2 = automaton.getStates();
        for (int i = 0; i < stateArray2.length; ++i) {
            State[] stateArray3 = this.getGroupMappedToState(stateArray2[i]);
            if (stateArray3 != stateArray) continue;
            return stateArray2[i];
        }
        return null;
    }

    public ArrayList getTransitionsForState(State state, Automaton automaton, Automaton automaton2, DefaultTreeModel defaultTreeModel) {
        ArrayList<FSATransition> arrayList = new ArrayList<FSATransition>();
        State[] stateArray = this.getGroupMappedToState(state);
        State state2 = stateArray[0];
        Transition[] transitionArray = automaton2.getTransitionsFromState(state2);
        for (int i = 0; i < transitionArray.length; ++i) {
            FSATransition fSATransition = (FSATransition)transitionArray[i];
            State state3 = fSATransition.getToState();
            State[] stateArray2 = this.getGroupForState(state3, defaultTreeModel);
            if (this.containsTrapState(stateArray2)) continue;
            State state4 = this.getStateMappedToGroup(stateArray2, automaton);
            FSATransition fSATransition2 = new FSATransition(state, state4, fSATransition.getLabel());
            arrayList.add(fSATransition2);
        }
        return arrayList;
    }

    public ArrayList getLeaves(DefaultTreeModel defaultTreeModel, MinimizeTreeNode minimizeTreeNode) {
        ArrayList<State[]> arrayList = new ArrayList<State[]>();
        if (defaultTreeModel.isLeaf(minimizeTreeNode)) {
            State[] stateArray = (State[])minimizeTreeNode.getUserObject();
            arrayList.add(stateArray);
        }
        for (int i = 0; i < minimizeTreeNode.getChildCount(); ++i) {
            MinimizeTreeNode minimizeTreeNode2 = (MinimizeTreeNode)minimizeTreeNode.getChildAt(i);
            arrayList.addAll(this.getLeaves(defaultTreeModel, minimizeTreeNode2));
        }
        return arrayList;
    }

    public boolean containsTrapState(State[] stateArray) {
        for (int i = 0; i < stateArray.length; ++i) {
            if (stateArray[i] != this.TRAP_STATE) continue;
            return true;
        }
        return false;
    }

    public FiniteStateAutomaton getMinimumDfa(Automaton automaton, DefaultTreeModel defaultTreeModel) {
        FiniteStateAutomaton finiteStateAutomaton = new FiniteStateAutomaton();
        this.createStatesForMinimumDfa(automaton, finiteStateAutomaton, defaultTreeModel);
        ArrayList arrayList = new ArrayList();
        State[] stateArray = finiteStateAutomaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            arrayList.addAll(this.getTransitionsForState(stateArray[i], finiteStateAutomaton, automaton, defaultTreeModel));
        }
        for (Transition transition : arrayList) {
            finiteStateAutomaton.addTransition(transition);
        }
        return finiteStateAutomaton;
    }
}

