/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.Automaton;
import automata.LambdaTransitionChecker;
import automata.fsa.FSALambdaTransitionChecker;
import automata.fsa.FiniteStateAutomaton;
import automata.mealy.MealyLambdaTransitionChecker;
import automata.mealy.MealyMachine;
import automata.pda.PDALambdaTransitionChecker;
import automata.pda.PushdownAutomaton;
import automata.turing.TMLambdaTransitionChecker;
import automata.turing.TuringMachine;

public class LambdaCheckerFactory {
    public static LambdaTransitionChecker getLambdaChecker(Automaton automaton) {
        if (automaton instanceof FiniteStateAutomaton) {
            return new FSALambdaTransitionChecker();
        }
        if (automaton instanceof PushdownAutomaton) {
            return new PDALambdaTransitionChecker();
        }
        if (automaton instanceof TuringMachine) {
            return new TMLambdaTransitionChecker();
        }
        if (automaton instanceof MealyMachine) {
            return new MealyLambdaTransitionChecker();
        }
        return null;
    }
}

